/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.cloud.storage.NotificationInfo;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageOptions;
import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.Objects;

public class Notification
extends NotificationInfo {
    private static final long serialVersionUID = 3150928330690874200L;
    private final StorageOptions options;
    private transient Storage storage;

    Notification(Storage storage, NotificationInfo.BuilderImpl infoBuilder) {
        super(infoBuilder);
        this.storage = (Storage)Preconditions.checkNotNull((Object)storage);
        this.options = (StorageOptions)storage.getOptions();
    }

    public Storage getStorage() {
        return this.storage;
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Notification)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Notification that = (Notification)o;
        return Objects.equals((Object)this.options, (Object)that.options) && Objects.equals(this.storage, that.storage);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.options, this.storage});
    }

    public static class Builder
    extends NotificationInfo.Builder {
        private final Storage storage;
        private final NotificationInfo.BuilderImpl infoBuilder;

        Builder(Notification notification) {
            this.storage = notification.storage;
            this.infoBuilder = new NotificationInfo.BuilderImpl(notification);
        }

        @Override
        Builder setNotificationId(String notificationId) {
            this.infoBuilder.setNotificationId(notificationId);
            return this;
        }

        @Override
        public Builder setSelfLink(String selfLink) {
            this.infoBuilder.setSelfLink(selfLink);
            return this;
        }

        @Override
        public Builder setTopic(String topic) {
            this.infoBuilder.setTopic(topic);
            return this;
        }

        @Override
        public Builder setPayloadFormat(NotificationInfo.PayloadFormat payloadFormat) {
            this.infoBuilder.setPayloadFormat(payloadFormat);
            return this;
        }

        @Override
        public Builder setObjectNamePrefix(String objectNamePrefix) {
            this.infoBuilder.setObjectNamePrefix(objectNamePrefix);
            return this;
        }

        @Override
        public Builder setEventTypes(NotificationInfo.EventType ... eventTypes) {
            this.infoBuilder.setEventTypes(eventTypes);
            return this;
        }

        @Override
        public Builder setEtag(String etag) {
            this.infoBuilder.setEtag(etag);
            return this;
        }

        @Override
        public Builder setCustomAttributes(Map<String, String> customAttributes) {
            this.infoBuilder.setCustomAttributes(customAttributes);
            return this;
        }

        @Override
        Builder setBucket(String bucket) {
            this.infoBuilder.setBucket(bucket);
            return this;
        }

        @Override
        public Notification build() {
            return new Notification(this.storage, this.infoBuilder);
        }
    }
}

