/*
 * Decompiled with CFR 0.152.
 */
package org.jf.baksmali;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.ParametersDelegate;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nonnull;
import org.jf.baksmali.AnalysisArguments;
import org.jf.baksmali.BaksmaliOptions;
import org.jf.baksmali.DexInputCommand;
import org.jf.dexlib2.AccessFlags;
import org.jf.dexlib2.analysis.ClassProto;
import org.jf.dexlib2.iface.ClassDef;
import org.jf.dexlib2.iface.Method;
import org.jf.util.jcommander.ExtendedParameter;
import org.jf.util.jcommander.ExtendedParameters;

@Parameters(commandDescription="Lists the virtual method tables for classes in a dex file.")
@ExtendedParameters(commandName="vtables", commandAliases={"vtable", "v"})
public class ListVtablesCommand
extends DexInputCommand {
    @Parameter(names={"-h", "-?", "--help"}, help=true, description="Show usage information")
    private boolean help;
    @ParametersDelegate
    private AnalysisArguments analysisArguments = new AnalysisArguments();
    @ParametersDelegate
    private AnalysisArguments.CheckPackagePrivateArgument checkPackagePrivateArgument = new AnalysisArguments.CheckPackagePrivateArgument();
    @Parameter(names={"--classes"}, description="A comma separated list of classes. Only print the vtable for these classes")
    @ExtendedParameter(argumentNames={"classes"})
    private List<String> classes = null;
    @Parameter(names={"--override-oat-version"}, description="Uses a classpath for the given oat version, regardless of the actual oat version. This can be used, e.g. to list vtables from a dex file, as if they were in an oat file of the given version.")
    private int oatVersion = 0;

    public ListVtablesCommand(@Nonnull List<JCommander> commandAncestors) {
        super(commandAncestors);
    }

    @Override
    public void run() {
        if (this.help || this.inputList == null || this.inputList.isEmpty()) {
            this.usage();
            return;
        }
        if (this.inputList.size() > 1) {
            System.err.println("Too many files specified");
            this.usage();
            return;
        }
        String input = (String)this.inputList.get(0);
        this.loadDexFile(input);
        BaksmaliOptions options = this.getOptions();
        if (options == null) {
            return;
        }
        try {
            if (this.classes != null && !this.classes.isEmpty()) {
                for (String string : this.classes) {
                    this.listClassVtable((ClassProto)options.classPath.getClass(string));
                }
                return;
            }
            for (ClassDef classDef : this.dexFile.getClasses()) {
                if (AccessFlags.INTERFACE.isSet(classDef.getAccessFlags())) continue;
                this.listClassVtable((ClassProto)options.classPath.getClass(classDef));
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void listClassVtable(ClassProto classProto) throws IOException {
        List<Method> methods = classProto.getVtable();
        String className = "Class " + classProto.getType() + " extends " + classProto.getSuperclass() + " : " + methods.size() + " methods\n";
        System.out.write(className.getBytes());
        for (int i = 0; i < methods.size(); ++i) {
            Method method = methods.get(i);
            String methodString = i + ":" + method.getDefiningClass() + "->" + method.getName() + "(";
            for (CharSequence charSequence : method.getParameterTypes()) {
                methodString = methodString + charSequence;
            }
            methodString = methodString + ")" + method.getReturnType() + "\n";
            System.out.write(methodString.getBytes());
        }
        System.out.write("\n".getBytes());
    }

    protected BaksmaliOptions getOptions() {
        if (this.dexFile == null) {
            throw new IllegalStateException("You must call loadDexFile first");
        }
        BaksmaliOptions options = new BaksmaliOptions();
        options.apiLevel = this.apiLevel;
        try {
            options.classPath = this.analysisArguments.loadClassPathForDexFile(this.inputFile.getAbsoluteFile().getParentFile(), this.dexEntry, this.checkPackagePrivateArgument.checkPackagePrivateAccess, this.oatVersion);
        }
        catch (Exception ex) {
            System.err.println("Error occurred while loading class path files.");
            ex.printStackTrace(System.err);
            return null;
        }
        return options;
    }
}

