/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.message.server;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.mariadb.jdbc.client.Completion;
import org.mariadb.jdbc.client.Context;
import org.mariadb.jdbc.client.ReadableByteBuf;
import org.mariadb.jdbc.util.log.Logger;
import org.mariadb.jdbc.util.log.Loggers;

public class OkPacket
implements Completion {
    private static final OkPacket BASIC_OK = new OkPacket(0L, 0L, null);
    private static final Logger logger = Loggers.getLogger(OkPacket.class);
    private final long affectedRows;
    private final long lastInsertId;
    private final byte[] info;
    static final byte[] CHARACTER_SET_CLIENT = "character_set_client".getBytes(StandardCharsets.UTF_8);
    static final byte[] CONNECTION_ID = "connection_id".getBytes(StandardCharsets.UTF_8);
    static final byte[] THREAD_CONNECTED = "threads_Connected".getBytes(StandardCharsets.UTF_8);
    static final byte[] AUTO_INCREMENT_INCREMENT = "auto_increment_increment".getBytes(StandardCharsets.UTF_8);
    static final byte[] MAXSCALE = "maxscale".getBytes(StandardCharsets.UTF_8);
    static final byte[] REDIRECT_URL = "redirect_url".getBytes(StandardCharsets.UTF_8);
    static final byte[] TX_ISOLATION = "tx_isolation".getBytes(StandardCharsets.UTF_8);
    static final byte[] TRANSACTION_ISOLATION = "transaction_isolation".getBytes(StandardCharsets.UTF_8);
    static final byte[] REPEATABLE_READ = "REPEATABLE-READ".getBytes(StandardCharsets.UTF_8);
    static final byte[] READ_UNCOMMITTED = "READ-UNCOMMITTED".getBytes(StandardCharsets.UTF_8);
    static final byte[] READ_COMMITTED = "READ-COMMITTED".getBytes(StandardCharsets.UTF_8);
    static final byte[] SERIALIZABLE = "SERIALIZABLE".getBytes(StandardCharsets.UTF_8);

    private OkPacket(long affectedRows, long lastInsertId, byte[] info) {
        this.affectedRows = affectedRows;
        this.lastInsertId = lastInsertId;
        this.info = info;
    }

    public static OkPacket parse(ReadableByteBuf buf, Context context) {
        buf.skip();
        long affectedRows = buf.readLongLengthEncodedNotNull();
        long lastInsertId = buf.readLongLengthEncodedNotNull();
        context.setServerStatus(buf.readUnsignedShort());
        context.setWarning(buf.readUnsignedShort());
        if (buf.readableBytes() > 0) {
            buf.skip(buf.readIntLengthEncodedNotNull());
            if (context.hasClientCapability(0x800000L)) {
                while (buf.readableBytes() > 0) {
                    ReadableByteBuf sessionStateBuf = buf.readLengthBuffer();
                    block5: while (sessionStateBuf.readableBytes() > 0) {
                        switch (sessionStateBuf.readByte()) {
                            case 0: {
                                ReadableByteBuf tmpBufsv;
                                do {
                                    byte[] valueBytes;
                                    tmpBufsv = sessionStateBuf.readLengthBuffer();
                                    int len = tmpBufsv.readIntLengthEncodedNotNull();
                                    byte[] variableBytes = new byte[len];
                                    tmpBufsv.readBytes(variableBytes);
                                    Integer lenSv = tmpBufsv.readLength();
                                    if (lenSv == null) {
                                        valueBytes = null;
                                    } else {
                                        valueBytes = new byte[lenSv.intValue()];
                                        tmpBufsv.readBytes(valueBytes);
                                    }
                                    if (logger.isDebugEnabled()) {
                                        logger.debug("System variable change:  {} = {}", new String(variableBytes, 0, len), valueBytes == null ? "null" : new String(valueBytes, 0, (int)lenSv));
                                    }
                                    if (Arrays.equals(CHARACTER_SET_CLIENT, variableBytes)) {
                                        context.setCharset(new String(valueBytes, 0, (int)lenSv));
                                        continue;
                                    }
                                    if (Arrays.equals(CONNECTION_ID, variableBytes)) {
                                        context.setThreadId(Long.parseLong(new String(valueBytes, 0, (int)lenSv)));
                                        continue;
                                    }
                                    if (Arrays.equals(THREAD_CONNECTED, variableBytes)) {
                                        context.setTreadsConnected(Long.parseLong(new String(valueBytes, 0, (int)lenSv)));
                                        continue;
                                    }
                                    if (Arrays.equals(AUTO_INCREMENT_INCREMENT, variableBytes)) {
                                        context.setAutoIncrement(Long.parseLong(new String(valueBytes, 0, (int)lenSv)));
                                        continue;
                                    }
                                    if (Arrays.equals(MAXSCALE, variableBytes)) {
                                        context.setMaxscaleVersion(new String(valueBytes, 0, (int)lenSv));
                                        continue;
                                    }
                                    if (Arrays.equals(REDIRECT_URL, variableBytes)) {
                                        if (lenSv == null || lenSv <= 0) continue;
                                        context.setRedirectUrl(new String(valueBytes, 0, (int)lenSv));
                                        continue;
                                    }
                                    if (!Arrays.equals(TX_ISOLATION, variableBytes) && !Arrays.equals(TRANSACTION_ISOLATION, variableBytes)) continue;
                                    if (Arrays.equals(REPEATABLE_READ, valueBytes)) {
                                        context.setTransactionIsolationLevel(4);
                                        continue;
                                    }
                                    if (Arrays.equals(READ_UNCOMMITTED, valueBytes)) {
                                        context.setTransactionIsolationLevel(1);
                                        continue;
                                    }
                                    if (Arrays.equals(READ_COMMITTED, valueBytes)) {
                                        context.setTransactionIsolationLevel(2);
                                        continue;
                                    }
                                    if (Arrays.equals(SERIALIZABLE, valueBytes)) {
                                        context.setTransactionIsolationLevel(8);
                                        continue;
                                    }
                                    context.setTransactionIsolationLevel(null);
                                } while (tmpBufsv.readableBytes() > 0);
                                continue block5;
                            }
                            case 1: {
                                sessionStateBuf.readIntLengthEncodedNotNull();
                                Integer dbLen = sessionStateBuf.readLength();
                                String database = dbLen == null || dbLen == 0 ? null : sessionStateBuf.readString(dbLen);
                                context.setDatabase(database);
                                logger.debug("Database change: is '{}'", database);
                                continue block5;
                            }
                        }
                        buf.skip(buf.readIntLengthEncodedNotNull());
                    }
                }
            }
        }
        if (affectedRows == 0L && lastInsertId == 0L) {
            return BASIC_OK;
        }
        return new OkPacket(affectedRows, lastInsertId, null);
    }

    public static OkPacket parseWithInfo(ReadableByteBuf buf, Context context) {
        byte[] info;
        buf.skip();
        long affectedRows = buf.readLongLengthEncodedNotNull();
        long lastInsertId = buf.readLongLengthEncodedNotNull();
        context.setServerStatus(buf.readUnsignedShort());
        context.setWarning(buf.readUnsignedShort());
        if (buf.readableBytes() > 0) {
            info = new byte[buf.readIntLengthEncodedNotNull()];
            buf.readBytes(info);
            if (context.hasClientCapability(0x800000L)) {
                while (buf.readableBytes() > 0) {
                    ReadableByteBuf sessionStateBuf = buf.readLengthBuffer();
                    block5: while (sessionStateBuf.readableBytes() > 0) {
                        switch (sessionStateBuf.readByte()) {
                            case 0: {
                                ReadableByteBuf tmpBufsv;
                                do {
                                    byte[] valueBytes;
                                    tmpBufsv = sessionStateBuf.readLengthBuffer();
                                    int len = tmpBufsv.readIntLengthEncodedNotNull();
                                    byte[] variableBytes = new byte[len];
                                    tmpBufsv.readBytes(variableBytes);
                                    Integer lenSv = tmpBufsv.readLength();
                                    if (lenSv == null) {
                                        valueBytes = null;
                                    } else {
                                        valueBytes = new byte[lenSv.intValue()];
                                        tmpBufsv.readBytes(valueBytes);
                                    }
                                    if (logger.isDebugEnabled()) {
                                        logger.debug("System variable change:  {} = {}", new String(variableBytes, 0, len), valueBytes == null ? "null" : new String(valueBytes, 0, (int)lenSv));
                                    }
                                    if (Arrays.equals(CHARACTER_SET_CLIENT, variableBytes)) {
                                        context.setCharset(new String(valueBytes, 0, (int)lenSv));
                                        continue;
                                    }
                                    if (Arrays.equals(CONNECTION_ID, variableBytes)) {
                                        context.setThreadId(Long.parseLong(new String(valueBytes, 0, (int)lenSv)));
                                        continue;
                                    }
                                    if (Arrays.equals(THREAD_CONNECTED, variableBytes)) {
                                        context.setTreadsConnected(Long.parseLong(new String(valueBytes, 0, (int)lenSv)));
                                        continue;
                                    }
                                    if (Arrays.equals(AUTO_INCREMENT_INCREMENT, variableBytes)) {
                                        context.setAutoIncrement(Long.parseLong(new String(valueBytes, 0, (int)lenSv)));
                                        continue;
                                    }
                                    if (Arrays.equals(REDIRECT_URL, variableBytes)) {
                                        if (lenSv == null || lenSv <= 0) continue;
                                        context.setRedirectUrl(new String(valueBytes, 0, (int)lenSv));
                                        continue;
                                    }
                                    if (!Arrays.equals(TX_ISOLATION, variableBytes) && !Arrays.equals(TRANSACTION_ISOLATION, variableBytes)) continue;
                                    if (Arrays.equals(REPEATABLE_READ, valueBytes)) {
                                        context.setTransactionIsolationLevel(4);
                                        continue;
                                    }
                                    if (Arrays.equals(READ_UNCOMMITTED, valueBytes)) {
                                        context.setTransactionIsolationLevel(1);
                                        continue;
                                    }
                                    if (Arrays.equals(READ_COMMITTED, valueBytes)) {
                                        context.setTransactionIsolationLevel(2);
                                        continue;
                                    }
                                    if (Arrays.equals(SERIALIZABLE, valueBytes)) {
                                        context.setTransactionIsolationLevel(8);
                                        continue;
                                    }
                                    context.setTransactionIsolationLevel(null);
                                } while (tmpBufsv.readableBytes() > 0);
                                continue block5;
                            }
                            case 1: {
                                sessionStateBuf.readIntLengthEncodedNotNull();
                                Integer dbLen = sessionStateBuf.readLength();
                                String database = dbLen == null || dbLen == 0 ? null : sessionStateBuf.readString(dbLen);
                                context.setDatabase(database);
                                logger.debug("Database change: is '{}'", database);
                                continue block5;
                            }
                        }
                        buf.skip(buf.readIntLengthEncodedNotNull());
                    }
                }
            }
        } else {
            info = new byte[]{};
        }
        return new OkPacket(affectedRows, lastInsertId, info);
    }

    public long getAffectedRows() {
        return this.affectedRows;
    }

    public long getLastInsertId() {
        return this.lastInsertId;
    }

    public byte[] getInfo() {
        return this.info;
    }
}

