/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.rowset;

import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.lang.reflect.Executable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.RowSet;
import javax.sql.RowSetInternal;
import javax.sql.RowSetWriter;
import oracle.jdbc.OraclePreparedStatement;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.jdbc.rowset.OracleCachedRowSet;
import oracle.jdbc.rowset.OracleCachedRowSetReader;
import oracle.jdbc.rowset.OracleRow;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.ROWSET})
public class OracleCachedRowSetWriter
implements RowSetWriter,
Serializable,
Monitor {
    static final long serialVersionUID = 8932894189919931169L;
    private StringBuffer updateClause;
    private StringBuffer deleteClause;
    private StringBuffer insertClause;
    private PreparedStatement insertStmt;
    private PreparedStatement updateStmt;
    private PreparedStatement deleteStmt;
    private ResultSetMetaData rsmd;
    private transient Connection connection;
    private int columnCount;
    static final int ASCII_STREAM = 1;
    static final int BINARY_STREAM = 2;
    static final int CHARACTER_STREAM = 3;
    static final int NCHARACTER_STREAM = 4;
    static final int ASCII_STREAM_LENGTH_UNSPECIFIED = 5;
    static final int BINARY_STREAM_LENGTH_UNSPECIFIED = 6;
    static final int CHARACTER_STREAM_LENGTH_UNSPECIFIED = 7;
    static final int NCHARACTER_STREAM_LENGTH_UNSPECIFIED = 8;
    private final Monitor.CloseableLock monitorLock;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;

    public OracleCachedRowSetWriter() {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$12, Level.FINEST, OracleCachedRowSetWriter.class, $$$methodRef$$$12, null, new Object[0]);
            }
            this.updateClause = new StringBuffer("");
            this.deleteClause = new StringBuffer("");
            this.insertClause = new StringBuffer("");
            this.monitorLock = this.newDefaultLock();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, OracleCachedRowSetWriter.class, $$$methodRef$$$12, null);
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, OracleCachedRowSetWriter.class, $$$methodRef$$$12, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, OracleCachedRowSetWriter.class, $$$methodRef$$$12, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private String getSchemaName(RowSet rowSet) throws SQLException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            void rowset;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, OracleCachedRowSetWriter.class, $$$methodRef$$$0, this, rowSet);
            }
            String string = rowset.getUsername();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, OracleCachedRowSetWriter.class, $$$methodRef$$$0, this, string);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OracleCachedRowSetWriter.class, $$$methodRef$$$0, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OracleCachedRowSetWriter.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private String getTableName(RowSet rowSet) throws SQLException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            StringTokenizer st;
            void rowset;
            String tableName;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, OracleCachedRowSetWriter.class, $$$methodRef$$$1, this, rowSet);
            }
            if ((tableName = ((OracleCachedRowSet)rowset).getTableName()) != null) {
                String string = tableName;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, OracleCachedRowSetWriter.class, $$$methodRef$$$1, this, string);
                    ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, OracleCachedRowSetWriter.class, $$$methodRef$$$1, this, null);
                }
                return string;
            }
            String cmd = rowset.getCommand();
            if (cmd == null) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(null, 343, "Please use RowSet.setCommand (String) to set the SQL query string.").fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, OracleCachedRowSetWriter.class, $$$methodRef$$$1, this, sQLException);
                }
                throw sQLException;
            }
            cmd = cmd.toUpperCase();
            if (bl) {
                this.debug($$$loggerRef$$$1, Level.FINEST, $$$methodRef$$$1, "OracleCachedRowSetWriter.getTableName(RowSet),cmd=" + cmd);
            }
            int index = cmd.indexOf(" FROM ");
            if (bl) {
                this.debug($$$loggerRef$$$1, Level.FINEST, $$$methodRef$$$1, "OracleCachedRowSetWriter.getTableName(RowSet),index=" + index);
            }
            if (index == -1) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(null, 343, cmd.length() != 0 ? cmd : "Please use RowSet.setCommand (String) to set the SQL query string.").fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, OracleCachedRowSetWriter.class, $$$methodRef$$$1, this, sQLException);
                }
                throw sQLException;
            }
            String tab = cmd.substring(index + 6).trim();
            if (bl) {
                this.debug($$$loggerRef$$$1, Level.FINEST, $$$methodRef$$$1, "OracleCachedRowSetWriter.getTableName(), tab=" + tab);
            }
            if ((st = new StringTokenizer(tab)).hasMoreTokens()) {
                tab = st.nextToken();
            }
            String string = tab;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, OracleCachedRowSetWriter.class, $$$methodRef$$$1, this, string);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, OracleCachedRowSetWriter.class, $$$methodRef$$$1, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, OracleCachedRowSetWriter.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void initSQLStatement(RowSet rowSet) throws SQLException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            int i2;
            void rowset;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, OracleCachedRowSetWriter.class, $$$methodRef$$$2, this, rowSet);
            }
            this.insertClause = new StringBuffer("INSERT INTO " + this.getTableName((RowSet)rowset) + "(");
            this.updateClause = new StringBuffer("UPDATE " + this.getTableName((RowSet)rowset) + " SET ");
            this.deleteClause = new StringBuffer("DELETE FROM " + this.getTableName((RowSet)rowset) + " WHERE ");
            this.rsmd = rowset.getMetaData();
            this.columnCount = this.rsmd.getColumnCount();
            if (bl) {
                this.debug($$$loggerRef$$$2, Level.FINEST, $$$methodRef$$$2, "OracleCachedRowSetWriter.initSQLStatement(RowSet), insertClause=" + this.insertClause + ", updateClause=" + this.updateClause + ", deleteClause=" + this.deleteClause + ", rsmd=" + this.rsmd + ", columnCount=" + this.columnCount);
            }
            for (i2 = 0; i2 < this.columnCount; ++i2) {
                if (i2 != 0) {
                    this.insertClause.append(", ");
                }
                this.insertClause.append(this.rsmd.getColumnName(i2 + 1));
                if (i2 != 0) {
                    this.updateClause.append(", ");
                }
                this.updateClause.append(this.rsmd.getColumnName(i2 + 1) + " = :" + i2);
                if (i2 != 0) {
                    this.deleteClause.append(" AND ");
                }
                this.deleteClause.append(this.rsmd.getColumnName(i2 + 1) + " = :" + i2);
            }
            this.insertClause.append(") VALUES (");
            this.updateClause.append(" WHERE ");
            for (i2 = 0; i2 < this.columnCount; ++i2) {
                if (i2 != 0) {
                    this.insertClause.append(", ");
                }
                this.insertClause.append(":" + i2);
                if (i2 != 0) {
                    this.updateClause.append(" AND ");
                }
                this.updateClause.append(this.rsmd.getColumnName(i2 + 1) + " = :" + i2);
            }
            this.insertClause.append(")");
            this.insertStmt = this.connection.prepareStatement(this.insertClause.substring(0, this.insertClause.length()));
            this.updateStmt = this.connection.prepareStatement(this.updateClause.substring(0, this.updateClause.length()));
            this.deleteStmt = this.connection.prepareStatement(this.deleteClause.substring(0, this.deleteClause.length()));
            if (bl) {
                this.debug($$$loggerRef$$$2, Level.FINEST, $$$methodRef$$$2, "OracleCachedRowSetWriter.initSQLStatement(RowSet), insertStmt=" + this.insertStmt + ", updateStmt=" + this.updateStmt + ", deleteStmt=" + this.deleteStmt);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, OracleCachedRowSetWriter.class, $$$methodRef$$$2, this);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OracleCachedRowSetWriter.class, $$$methodRef$$$2, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OracleCachedRowSetWriter.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean insertRow(OracleRow oracleRow) throws SQLException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            boolean bl2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, OracleCachedRowSetWriter.class, $$$methodRef$$$3, this, oracleRow);
            }
            this.insertStmt.clearParameters();
            for (int i2 = 1; i2 <= this.columnCount; ++i2) {
                void row;
                Object o2 = null;
                Object object = o2 = row.isColumnChanged(i2) ? row.getModifiedColumn(i2) : row.getColumn(i2);
                if (bl) {
                    this.debug($$$loggerRef$$$3, Level.FINEST, $$$methodRef$$$3, "OracleCachedRowSetWriter.insertRow(OracleRow), o=" + o2);
                }
                if (o2 == null) {
                    this.insertStmt.setNull(i2, this.rsmd.getColumnType(i2), this.rsmd.getColumnTypeName(i2));
                    row.markOriginalNull(i2, true);
                    continue;
                }
                this.insertStmt.setObject(i2, o2);
            }
            boolean bl3 = bl2 = this.insertStmt.executeUpdate() == 1;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, OracleCachedRowSetWriter.class, $$$methodRef$$$3, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, OracleCachedRowSetWriter.class, $$$methodRef$$$3, this, null);
            }
            return bl3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, OracleCachedRowSetWriter.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean updateRow(RowSet rowSet, OracleRow oracleRow) throws SQLException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            void rowset;
            void row;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, OracleCachedRowSetWriter.class, $$$methodRef$$$4, this, rowSet, oracleRow);
            }
            for (int i2 = 1; i2 <= this.columnCount; ++i2) {
                if (!row.isOriginalNull(i2)) continue;
                boolean bl2 = this.updateRowWithNull((RowSet)rowset, (OracleRow)row);
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, OracleCachedRowSetWriter.class, $$$methodRef$$$4, this, bl2);
                    ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OracleCachedRowSetWriter.class, $$$methodRef$$$4, this, null);
                }
                return bl2;
            }
            boolean bl3 = this.updateRowNoNulls((RowSet)rowset, (OracleRow)row);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, OracleCachedRowSetWriter.class, $$$methodRef$$$4, this, bl3);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OracleCachedRowSetWriter.class, $$$methodRef$$$4, this, null);
            }
            return bl3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OracleCachedRowSetWriter.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean updateRowNoNulls(RowSet rowSet, OracleRow oracleRow) throws SQLException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            boolean bl2;
            void row;
            int i2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, OracleCachedRowSetWriter.class, $$$methodRef$$$5, this, rowSet, oracleRow);
            }
            this.updateStmt.clearParameters();
            for (i2 = 1; i2 <= this.columnCount; ++i2) {
                Object o2 = null;
                Object object = o2 = row.isColumnChanged(i2) ? row.getModifiedColumn(i2) : row.getColumn(i2);
                if (bl) {
                    this.debug($$$loggerRef$$$5, Level.FINEST, $$$methodRef$$$5, "OracleCachedRowSetWriter.updateRow(OracleRow), o=" + o2);
                }
                if (o2 == null) {
                    this.updateStmt.setNull(i2, this.rsmd.getColumnType(i2), this.rsmd.getColumnTypeName(i2));
                    continue;
                }
                if (o2 instanceof Reader) {
                    boolean lengthUnspecified = false;
                    OraclePreparedStatement pstmt = (OraclePreparedStatement)this.updateStmt;
                    if (row.columnTypeInfo[i2 - 1][1] == 4L) {
                        pstmt.setFormOfUse(i2, (short)2);
                    } else if (row.columnTypeInfo[i2 - 1][1] == 3L) {
                        pstmt.setFormOfUse(i2, (short)1);
                    } else if (row.columnTypeInfo[i2 - 1][1] == 8L) {
                        lengthUnspecified = true;
                        pstmt.setFormOfUse(i2, (short)2);
                    } else if (row.columnTypeInfo[i2 - 1][1] == 7L) {
                        lengthUnspecified = true;
                        pstmt.setFormOfUse(i2, (short)1);
                    }
                    if (lengthUnspecified) {
                        this.updateStmt.setCharacterStream(i2, (Reader)o2);
                        continue;
                    }
                    this.updateStmt.setCharacterStream(i2, (Reader)o2, row.columnTypeInfo[i2 - 1][0]);
                    continue;
                }
                if (o2 instanceof InputStream) {
                    if (row.columnTypeInfo[i2 - 1][1] == 2L) {
                        this.updateStmt.setBinaryStream(i2, (InputStream)o2, row.columnTypeInfo[i2 - 1][0]);
                        continue;
                    }
                    if (row.columnTypeInfo[i2 - 1][1] == 6L) {
                        this.updateStmt.setBinaryStream(i2, (InputStream)o2);
                        continue;
                    }
                    if (row.columnTypeInfo[i2 - 1][1] == 1L) {
                        this.updateStmt.setAsciiStream(i2, (InputStream)o2, row.columnTypeInfo[i2 - 1][0]);
                        continue;
                    }
                    if (row.columnTypeInfo[i2 - 1][1] != 5L) continue;
                    this.updateStmt.setAsciiStream(i2, (InputStream)o2);
                    continue;
                }
                this.updateStmt.setObject(i2, o2);
            }
            for (i2 = 1; i2 <= this.columnCount; ++i2) {
                this.updateStmt.setObject(i2 + this.columnCount, row.getColumn(i2));
            }
            boolean bl3 = bl2 = this.updateStmt.executeUpdate() == 1;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, OracleCachedRowSetWriter.class, $$$methodRef$$$5, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, OracleCachedRowSetWriter.class, $$$methodRef$$$5, this, null);
            }
            return bl3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, OracleCachedRowSetWriter.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean updateRowWithNull(RowSet rowSet, OracleRow oracleRow) throws SQLException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            boolean returnValue;
            block31: {
                void row;
                int i2;
                void rowset;
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, OracleCachedRowSetWriter.class, $$$methodRef$$$6, this, rowSet, oracleRow);
                }
                returnValue = false;
                StringBuffer updateClauseWithNull = new StringBuffer("UPDATE " + this.getTableName((RowSet)rowset) + " SET ");
                for (i2 = 1; i2 <= this.columnCount; ++i2) {
                    if (i2 != 1) {
                        updateClauseWithNull.append(", ");
                    }
                    updateClauseWithNull.append(this.rsmd.getColumnName(i2) + " = :" + i2);
                }
                updateClauseWithNull.append(" WHERE ");
                for (i2 = 1; i2 <= this.columnCount; ++i2) {
                    if (i2 != 1) {
                        updateClauseWithNull.append(" AND ");
                    }
                    if (row.isOriginalNull(i2)) {
                        updateClauseWithNull.append(this.rsmd.getColumnName(i2) + " IS NULL ");
                        continue;
                    }
                    updateClauseWithNull.append(this.rsmd.getColumnName(i2) + " = :" + i2);
                }
                Statement stmt = null;
                try {
                    int i3;
                    stmt = this.connection.prepareStatement(updateClauseWithNull.substring(0, updateClauseWithNull.length()));
                    for (i3 = 1; i3 <= this.columnCount; ++i3) {
                        Object o2 = null;
                        Object object = o2 = row.isColumnChanged(i3) ? row.getModifiedColumn(i3) : row.getColumn(i3);
                        if (bl) {
                            this.debug($$$loggerRef$$$6, Level.FINEST, $$$methodRef$$$6, "OracleCachedRowSetWriter.updateRowWithNull(OracleRow), o=" + o2);
                        }
                        if (o2 == null) {
                            stmt.setNull(i3, this.rsmd.getColumnType(i3), this.rsmd.getColumnTypeName(i3));
                            continue;
                        }
                        if (o2 instanceof Reader) {
                            boolean lengthUnspecified = false;
                            OraclePreparedStatement pstmt = (OraclePreparedStatement)stmt;
                            if (row.columnTypeInfo[i3 - 1][1] == 4L) {
                                pstmt.setFormOfUse(i3, (short)2);
                            } else if (row.columnTypeInfo[i3 - 1][1] == 3L) {
                                pstmt.setFormOfUse(i3, (short)1);
                            } else if (row.columnTypeInfo[i3 - 1][1] == 8L) {
                                lengthUnspecified = true;
                                pstmt.setFormOfUse(i3, (short)2);
                            } else if (row.columnTypeInfo[i3 - 1][1] == 7L) {
                                lengthUnspecified = true;
                                pstmt.setFormOfUse(i3, (short)1);
                            }
                            if (lengthUnspecified) {
                                stmt.setCharacterStream(i3, (Reader)o2);
                                continue;
                            }
                            stmt.setCharacterStream(i3, (Reader)o2, row.columnTypeInfo[i3 - 1][0]);
                            continue;
                        }
                        if (o2 instanceof InputStream) {
                            if (row.columnTypeInfo[i3 - 1][1] == 2L) {
                                stmt.setBinaryStream(i3, (InputStream)o2, row.columnTypeInfo[i3 - 1][0]);
                                continue;
                            }
                            if (row.columnTypeInfo[i3 - 1][1] == 6L) {
                                stmt.setBinaryStream(i3, (InputStream)o2);
                                continue;
                            }
                            if (row.columnTypeInfo[i3 - 1][1] == 1L) {
                                stmt.setAsciiStream(i3, (InputStream)o2, row.columnTypeInfo[i3 - 1][0]);
                                continue;
                            }
                            if (row.columnTypeInfo[i3 - 1][1] != 5L) continue;
                            stmt.setAsciiStream(i3, (InputStream)o2);
                            continue;
                        }
                        stmt.setObject(i3, o2);
                    }
                    int columnIndex = 1;
                    for (i3 = 1; i3 <= this.columnCount; ++i3) {
                        if (row.isOriginalNull(i3)) continue;
                        stmt.setObject(columnIndex + this.columnCount, row.getColumn(i3));
                        ++columnIndex;
                    }
                    boolean bl2 = returnValue = stmt.executeUpdate() == 1;
                    if (stmt == null) break block31;
                }
                catch (Throwable throwable) {
                    if (stmt != null) {
                        stmt.close();
                    }
                    Throwable throwable2 = throwable;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$6, Level.FINEST, OracleCachedRowSetWriter.class, $$$methodRef$$$6, this, throwable2);
                    }
                    throw throwable2;
                }
                stmt.close();
            }
            boolean bl3 = returnValue;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, OracleCachedRowSetWriter.class, $$$methodRef$$$6, this, bl3);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, OracleCachedRowSetWriter.class, $$$methodRef$$$6, this, null);
            }
            return bl3;
        }
        catch (Throwable throwable) {
            Throwable throwable3 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, OracleCachedRowSetWriter.class, $$$methodRef$$$6, this, throwable3);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean deleteRow(RowSet rowSet, OracleRow oracleRow) throws SQLException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            boolean bl2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, OracleCachedRowSetWriter.class, $$$methodRef$$$7, this, rowSet, oracleRow);
            }
            this.deleteStmt.clearParameters();
            for (int i2 = 1; i2 <= this.columnCount; ++i2) {
                void row;
                if (row.isOriginalNull(i2)) {
                    void rowset;
                    boolean bl3 = this.deleteRowWithNull((RowSet)rowset, (OracleRow)row);
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, OracleCachedRowSetWriter.class, $$$methodRef$$$7, this, bl3);
                        ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, OracleCachedRowSetWriter.class, $$$methodRef$$$7, this, null);
                    }
                    return bl3;
                }
                Object o2 = row.getColumn(i2);
                if (o2 == null) {
                    this.deleteStmt.setNull(i2, this.rsmd.getColumnType(i2), this.rsmd.getColumnTypeName(i2));
                    continue;
                }
                this.deleteStmt.setObject(i2, o2);
            }
            boolean bl4 = bl2 = this.deleteStmt.executeUpdate() == 1;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, OracleCachedRowSetWriter.class, $$$methodRef$$$7, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, OracleCachedRowSetWriter.class, $$$methodRef$$$7, this, null);
            }
            return bl4;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, OracleCachedRowSetWriter.class, $$$methodRef$$$7, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean deleteRowWithNull(RowSet rowSet, OracleRow oracleRow) throws SQLException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            boolean returnValue;
            block13: {
                void row;
                void rowset;
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, OracleCachedRowSetWriter.class, $$$methodRef$$$8, this, rowSet, oracleRow);
                }
                returnValue = false;
                StringBuffer deleteClauseWithNull = new StringBuffer("DELETE FROM " + this.getTableName((RowSet)rowset) + " WHERE ");
                for (int i2 = 1; i2 <= this.columnCount; ++i2) {
                    if (i2 != 1) {
                        deleteClauseWithNull.append(" AND ");
                    }
                    if (row.isOriginalNull(i2)) {
                        deleteClauseWithNull.append(this.rsmd.getColumnName(i2) + " IS NULL ");
                        continue;
                    }
                    deleteClauseWithNull.append(this.rsmd.getColumnName(i2) + " = :" + i2);
                }
                Statement stmt = null;
                try {
                    stmt = this.connection.prepareStatement(deleteClauseWithNull.substring(0, deleteClauseWithNull.length()));
                    int columnIndex = 1;
                    for (int i3 = 1; i3 <= this.columnCount; ++i3) {
                        if (row.isOriginalNull(i3)) continue;
                        stmt.setObject(columnIndex++, row.getColumn(i3));
                    }
                    boolean bl2 = returnValue = stmt.executeUpdate() == 1;
                    if (stmt == null) break block13;
                }
                catch (Throwable throwable) {
                    if (stmt != null) {
                        stmt.close();
                    }
                    Throwable throwable2 = throwable;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$8, Level.FINEST, OracleCachedRowSetWriter.class, $$$methodRef$$$8, this, throwable2);
                    }
                    throw throwable2;
                }
                stmt.close();
            }
            boolean bl3 = returnValue;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, OracleCachedRowSetWriter.class, $$$methodRef$$$8, this, bl3);
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, OracleCachedRowSetWriter.class, $$$methodRef$$$8, this, null);
            }
            return bl3;
        }
        catch (Throwable throwable) {
            Throwable throwable3 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, OracleCachedRowSetWriter.class, $$$methodRef$$$8, this, throwable3);
            }
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     */
    @Override
    public boolean writeData(RowSetInternal rowSetInternal) throws SQLException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            boolean bl2;
            Throwable throwable;
            Monitor.CloseableLock lock;
            block39: {
                block40: {
                    OracleCachedRowSet rowset;
                    block36: {
                        boolean exc2222222222;
                        block37: {
                            block38: {
                                block35: {
                                    void rowsetInternal;
                                    if (bl) {
                                        ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, OracleCachedRowSetWriter.class, $$$methodRef$$$9, this, rowSetInternal);
                                    }
                                    lock = this.acquireCloseableLock();
                                    throwable = null;
                                    rowset = (OracleCachedRowSet)rowsetInternal;
                                    this.connection = ((OracleCachedRowSetReader)rowset.getReader()).getConnection((RowSetInternal)rowsetInternal);
                                    if (bl) {
                                        this.debug($$$loggerRef$$$9, Level.FINEST, $$$methodRef$$$9, "OracleCachedRowSetWriter.writeData(RowSetInternal),connection=" + this.connection + ",columnCount=" + this.columnCount);
                                    }
                                    if (this.connection == null) {
                                        SQLException sQLException = (SQLException)DatabaseError.createSqlException(342).fillInStackTrace();
                                        if (bl) {
                                            ClioSupport.throwing($$$loggerRef$$$9, Level.FINEST, OracleCachedRowSetWriter.class, $$$methodRef$$$9, this, sQLException);
                                        }
                                        throw sQLException;
                                    }
                                    if (this.connection.getAutoCommit()) {
                                        this.connection.setAutoCommit(false);
                                    }
                                    try {
                                        this.connection.setTransactionIsolation(rowset.getTransactionIsolation());
                                    }
                                    catch (Exception exc2222222222) {
                                        if (!bl) break block35;
                                        this.debug($$$loggerRef$$$9, Level.FINEST, $$$methodRef$$$9, "OracleCachedRowSetWriter.writeData(), setTransactionIsolation() throws exception: " + exc2222222222);
                                    }
                                }
                                this.initSQLStatement(rowset);
                                if (this.columnCount >= 1) break block36;
                                this.connection.close();
                                exc2222222222 = true;
                                if (lock == null) break block37;
                                if (throwable == null) break block38;
                                try {
                                    lock.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                break block37;
                            }
                            lock.close();
                        }
                        boolean bl3 = exc2222222222;
                        if (bl) {
                            ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, OracleCachedRowSetWriter.class, $$$methodRef$$$9, this, bl3);
                            ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, OracleCachedRowSetWriter.class, $$$methodRef$$$9, this, null);
                        }
                        return bl3;
                    }
                    boolean oldFlag = rowset.getShowDeleted();
                    rowset.setShowDeleted(true);
                    rowset.beforeFirst();
                    boolean updateFlag = true;
                    boolean insertFlag = true;
                    boolean deleteFlag = true;
                    OracleRow row = null;
                    while (rowset.next()) {
                        if (rowset.rowInserted()) {
                            if (rowset.rowDeleted()) continue;
                            row = rowset.getCurrentRow();
                            insertFlag = this.insertRow(row) || insertFlag;
                            continue;
                        }
                        if (rowset.rowUpdated()) {
                            row = rowset.getCurrentRow();
                            updateFlag = this.updateRow(rowset, row) || updateFlag;
                            continue;
                        }
                        if (!rowset.rowDeleted()) continue;
                        row = rowset.getCurrentRow();
                        deleteFlag = this.deleteRow(rowset, row) || deleteFlag;
                    }
                    if (bl) {
                        this.debug($$$loggerRef$$$9, Level.FINEST, $$$methodRef$$$9, "OracleCachedRowSetWriter.writeData(RowSetInternal),oldFlag=" + oldFlag + ", updateFlag=" + updateFlag + ", insertFlag=" + insertFlag + ", deleteFlag" + deleteFlag + ", row=" + row);
                    }
                    if (updateFlag && insertFlag && deleteFlag) {
                        this.connection.commit();
                        rowset.setOriginal();
                    } else {
                        this.connection.rollback();
                    }
                    this.insertStmt.close();
                    this.updateStmt.close();
                    this.deleteStmt.close();
                    if (!rowset.isConnectionStayingOpen()) {
                        this.connection.close();
                    }
                    rowset.setShowDeleted(oldFlag);
                    bl2 = true;
                    if (lock == null) break block39;
                    if (throwable == null) break block40;
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    break block39;
                }
                lock.close();
            }
            boolean bl4 = bl2;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, OracleCachedRowSetWriter.class, $$$methodRef$$$9, this, bl4);
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, OracleCachedRowSetWriter.class, $$$methodRef$$$9, this, null);
            }
            return bl4;
            catch (Throwable throwable4) {
                try {
                    throwable = throwable4;
                    Throwable throwable5 = throwable4;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$9, Level.FINEST, OracleCachedRowSetWriter.class, $$$methodRef$$$9, this, throwable5);
                    }
                    throw throwable5;
                }
                catch (Throwable throwable6) {
                    if (lock != null) {
                        if (throwable != null) {
                            try {
                                lock.close();
                            }
                            catch (Throwable throwable7) {
                                throwable.addSuppressed(throwable7);
                            }
                        } else {
                            lock.close();
                        }
                    }
                    Throwable throwable8 = throwable6;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$9, Level.FINEST, OracleCachedRowSetWriter.class, $$$methodRef$$$9, this, throwable8);
                    }
                    throw throwable8;
                }
            }
        }
        catch (Throwable throwable) {
            Throwable throwable9 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, OracleCachedRowSetWriter.class, $$$methodRef$$$9, this, throwable9);
            }
            throw throwable;
        }
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, OracleCachedRowSetWriter.class, $$$methodRef$$$10, this, new Object[0]);
            }
            OracleConnection oracleConnection = null;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, OracleCachedRowSetWriter.class, $$$methodRef$$$10, this, oracleConnection);
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, OracleCachedRowSetWriter.class, $$$methodRef$$$10, this, null);
            }
            return null;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, OracleCachedRowSetWriter.class, $$$methodRef$$$10, this, throwable2);
            }
            throw throwable;
        }
    }

    @Log
    protected void debug(Logger logger, Level level, Executable method, String msg) {
        ClioSupport.log(logger, level, this.getClass(), method, msg);
    }

    @Override
    public final Monitor.CloseableLock getMonitorLock() {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, OracleCachedRowSetWriter.class, $$$methodRef$$$11, this, new Object[0]);
            }
            Monitor.CloseableLock closeableLock = this.monitorLock;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, OracleCachedRowSetWriter.class, $$$methodRef$$$11, this, closeableLock);
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, OracleCachedRowSetWriter.class, $$$methodRef$$$11, this, null);
            }
            return closeableLock;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, OracleCachedRowSetWriter.class, $$$methodRef$$$11, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$12 = OracleCachedRowSetWriter.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = OracleCachedRowSetWriter.class.getDeclaredMethod("getMonitorLock", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = OracleCachedRowSetWriter.class.getDeclaredMethod("getConnectionDuringExceptionHandling", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = OracleCachedRowSetWriter.class.getDeclaredMethod("writeData", RowSetInternal.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = OracleCachedRowSetWriter.class.getDeclaredMethod("deleteRowWithNull", RowSet.class, OracleRow.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = OracleCachedRowSetWriter.class.getDeclaredMethod("deleteRow", RowSet.class, OracleRow.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = OracleCachedRowSetWriter.class.getDeclaredMethod("updateRowWithNull", RowSet.class, OracleRow.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = OracleCachedRowSetWriter.class.getDeclaredMethod("updateRowNoNulls", RowSet.class, OracleRow.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = OracleCachedRowSetWriter.class.getDeclaredMethod("updateRow", RowSet.class, OracleRow.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = OracleCachedRowSetWriter.class.getDeclaredMethod("insertRow", OracleRow.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = OracleCachedRowSetWriter.class.getDeclaredMethod("initSQLStatement", RowSet.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = OracleCachedRowSetWriter.class.getDeclaredMethod("getTableName", RowSet.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = OracleCachedRowSetWriter.class.getDeclaredMethod("getSchemaName", RowSet.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

