/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.util;

import com.amazon.redshift.logger.LogLevel;
import com.amazon.redshift.logger.RedshiftLogger;
import java.util.Timer;
import java.util.concurrent.atomic.AtomicInteger;

public class SharedTimer {
    private static final AtomicInteger timerCount = new AtomicInteger(0);
    private static final RedshiftLogger logger = RedshiftLogger.getDriverLogger();
    private volatile Timer timer = null;
    private final AtomicInteger refCount = new AtomicInteger(0);

    public int getRefCount() {
        return this.refCount.get();
    }

    public synchronized Timer getTimer() {
        if (this.timer == null) {
            int index = timerCount.incrementAndGet();
            ClassLoader prevContextCL = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(null);
                this.timer = new Timer("Redshift-JDBC-SharedTimer-" + index, true);
            }
            finally {
                Thread.currentThread().setContextClassLoader(prevContextCL);
            }
        }
        this.refCount.incrementAndGet();
        return this.timer;
    }

    public synchronized void releaseTimer() {
        int count = this.refCount.decrementAndGet();
        if (count > 0) {
            if (RedshiftLogger.isEnable() && logger != null) {
                logger.log(LogLevel.DEBUG, "Outstanding references still exist so not closing shared Timer", new Object[0]);
            }
        } else if (count == 0) {
            if (RedshiftLogger.isEnable() && logger != null) {
                logger.log(LogLevel.DEBUG, "No outstanding references to shared Timer, will cancel and close it", new Object[0]);
            }
            if (this.timer != null) {
                this.timer.cancel();
                this.timer = null;
            }
        } else {
            if (RedshiftLogger.isEnable() && logger != null) {
                logger.log(LogLevel.INFO, "releaseTimer() called too many times; there is probably a bug in the calling code", new Object[0]);
            }
            this.refCount.set(0);
        }
    }
}

