/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAxiomVisitor;
import org.semanticweb.owlapi.model.OWLAxiomVisitorEx;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import uk.ac.manchester.cs.owl.owlapi.OWLClassAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDisjointClassesAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLEquivalentClassesAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectUnionOfImpl;

public class OWLDisjointUnionAxiomImpl
extends OWLClassAxiomImpl
implements OWLDisjointUnionAxiom {
    private static final long serialVersionUID = 40000L;
    @Nonnull
    private final OWLClass owlClass;
    @Nonnull
    private final List<OWLClassExpression> classExpressions;

    public OWLDisjointUnionAxiomImpl(@Nonnull OWLClass owlClass, @Nonnull Set<? extends OWLClassExpression> classExpressions, @Nonnull Set<? extends OWLAnnotation> annotations) {
        super(annotations);
        this.owlClass = OWLAPIPreconditions.checkNotNull(owlClass, "owlClass cannot be null");
        OWLAPIPreconditions.checkNotNull(classExpressions, "classExpressions cannot be null");
        this.classExpressions = CollectionFactory.sortOptionally(classExpressions);
    }

    @Override
    public Set<OWLClassExpression> getClassExpressions() {
        return CollectionFactory.getCopyOnRequestSetFromImmutableCollection(this.classExpressions);
    }

    @Override
    public OWLDisjointUnionAxiom getAxiomWithoutAnnotations() {
        if (!this.isAnnotated()) {
            return this;
        }
        return new OWLDisjointUnionAxiomImpl(this.getOWLClass(), this.getClassExpressions(), NO_ANNOTATIONS);
    }

    @Override
    public OWLDisjointUnionAxiom getAnnotatedAxiom(Set<OWLAnnotation> annotations) {
        return new OWLDisjointUnionAxiomImpl(this.getOWLClass(), this.getClassExpressions(), this.mergeAnnos(annotations));
    }

    @Override
    public OWLClass getOWLClass() {
        return this.owlClass;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof OWLDisjointUnionAxiom)) {
            return false;
        }
        if (obj instanceof OWLDisjointUnionAxiomImpl) {
            OWLDisjointUnionAxiomImpl other = (OWLDisjointUnionAxiomImpl)obj;
            return this.owlClass.equals(other.owlClass) && this.classExpressions.equals(other.classExpressions);
        }
        OWLDisjointUnionAxiom other = (OWLDisjointUnionAxiom)obj;
        return other.getOWLClass().equals(this.owlClass) && other.getClassExpressions().equals(this.getClassExpressions());
    }

    @Override
    public void accept(OWLAxiomVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void accept(OWLObjectVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <O> O accept(OWLAxiomVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    public <O> O accept(OWLObjectVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    public AxiomType<?> getAxiomType() {
        return AxiomType.DISJOINT_UNION;
    }

    @Override
    public OWLEquivalentClassesAxiom getOWLEquivalentClassesAxiom() {
        return new OWLEquivalentClassesAxiomImpl(new HashSet<OWLClassExpression>(Arrays.asList(this.owlClass, new OWLObjectUnionOfImpl(this.getClassExpressions()))), NO_ANNOTATIONS);
    }

    @Override
    public OWLDisjointClassesAxiom getOWLDisjointClassesAxiom() {
        return new OWLDisjointClassesAxiomImpl(this.getClassExpressions(), NO_ANNOTATIONS);
    }

    @Override
    protected int compareObjectOfSameType(OWLObject object) {
        OWLDisjointUnionAxiom other = (OWLDisjointUnionAxiom)object;
        int diff = this.owlClass.compareTo(other.getOWLClass());
        if (diff != 0) {
            return diff;
        }
        return OWLDisjointUnionAxiomImpl.compareSets(this.classExpressions, other.getClassExpressions());
    }
}

