/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.core.xml.config;

import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nonnull;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.core.config.InitializationException;
import org.opensaml.core.config.Initializer;
import org.opensaml.core.xml.config.XMLConfigurationException;
import org.opensaml.core.xml.config.XMLConfigurator;
import org.slf4j.Logger;

public abstract class AbstractXMLObjectProviderInitializer
implements Initializer {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AbstractXMLObjectProviderInitializer.class);

    @Override
    public void init() throws InitializationException {
        try {
            XMLConfigurator configurator = new XMLConfigurator();
            for (String resource : this.getConfigResources()) {
                if (resource.startsWith("/")) {
                    resource = resource.substring(1);
                }
                this.log.debug("Loading XMLObject provider configuration from resource '{}'", (Object)resource);
                try (InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(resource);){
                    if (is != null) {
                        configurator.load(is);
                        continue;
                    }
                    throw new XMLConfigurationException("Resource not found: " + resource);
                }
                catch (IOException e) {
                    throw new XMLConfigurationException("Error loading resource: " + resource, e);
                }
            }
        }
        catch (XMLConfigurationException e) {
            this.log.error("Problem loading configuration resource: {}", (Object)e.getMessage());
            throw new InitializationException("Problem loading configuration resource", e);
        }
    }

    @Nonnull
    protected abstract String[] getConfigResources();
}

