/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.primitives.model;

import java.util.Objects;
import software.amazon.cryptography.primitives.model.ECDHCurveSpec;

public class GenerateECCKeyPairInput {
    private final ECDHCurveSpec eccCurve;

    protected GenerateECCKeyPairInput(BuilderImpl builder) {
        this.eccCurve = builder.eccCurve();
    }

    public ECDHCurveSpec eccCurve() {
        return this.eccCurve;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected ECDHCurveSpec eccCurve;

        protected BuilderImpl() {
        }

        protected BuilderImpl(GenerateECCKeyPairInput model) {
            this.eccCurve = model.eccCurve();
        }

        @Override
        public Builder eccCurve(ECDHCurveSpec eccCurve) {
            this.eccCurve = eccCurve;
            return this;
        }

        @Override
        public ECDHCurveSpec eccCurve() {
            return this.eccCurve;
        }

        @Override
        public GenerateECCKeyPairInput build() {
            if (Objects.isNull((Object)this.eccCurve())) {
                throw new IllegalArgumentException("Missing value for required field `eccCurve`");
            }
            return new GenerateECCKeyPairInput(this);
        }
    }

    public static interface Builder {
        public Builder eccCurve(ECDHCurveSpec var1);

        public ECDHCurveSpec eccCurve();

        public GenerateECCKeyPairInput build();
    }
}

