/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.connector.functions.preprocess;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opensearch.ml.common.connector.functions.preprocess.ConnectorPreProcessFunction;
import org.opensearch.ml.common.dataset.TextDocsInputDataSet;
import org.opensearch.ml.common.dataset.remote.RemoteInferenceInputDataSet;
import org.opensearch.ml.common.input.MLInput;
import org.opensearch.ml.common.utils.StringUtils;

public class VideoEmbeddingPreProcessFunction
extends ConnectorPreProcessFunction {
    public VideoEmbeddingPreProcessFunction() {
        this.returnDirectlyForRemoteInferenceInput = true;
    }

    @Override
    public void validate(MLInput mlInput) {
        this.validateTextDocsInput(mlInput);
        List<String> docs = ((TextDocsInputDataSet)mlInput.getInputDataset()).getDocs();
        if (docs.size() == 0) {
            throw new IllegalArgumentException("No input video provided");
        }
    }

    @Override
    public RemoteInferenceInputDataSet process(MLInput mlInput) {
        TextDocsInputDataSet inputData = (TextDocsInputDataSet)mlInput.getInputDataset();
        HashMap<String, String> parametersMap = new HashMap<String, String>();
        parametersMap.put("inputVideo", inputData.getDocs().get(0));
        return RemoteInferenceInputDataSet.builder().parameters(StringUtils.convertScriptStringToJsonString(Map.of("parameters", parametersMap))).build();
    }
}

