/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.helper;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.ml.common.memorycontainer.MemoryStrategy;
import org.opensearch.ml.common.memorycontainer.MemoryStrategyType;

public class StrategyMergeHelper {
    @Generated
    private static final Logger log = LogManager.getLogger(StrategyMergeHelper.class);

    public static List<MemoryStrategy> mergeStrategies(List<MemoryStrategy> existing, List<MemoryStrategy> updates) {
        if (existing == null) {
            existing = new ArrayList<MemoryStrategy>();
        }
        if (updates == null || updates.isEmpty()) {
            return existing;
        }
        Map strategyMap = existing.stream().collect(Collectors.toMap(MemoryStrategy::getId, Function.identity()));
        for (MemoryStrategy update : updates) {
            if (update.getId() != null && !update.getId().isBlank()) {
                MemoryStrategy existingStrategy = (MemoryStrategy)strategyMap.get(update.getId());
                if (existingStrategy == null) {
                    log.error("Strategy with id {} not found", (Object)update.getId());
                    throw new OpenSearchStatusException("Strategy with id " + update.getId() + " not found", RestStatus.NOT_FOUND, new Object[0]);
                }
                if (update.getType() != null && !update.getType().equals((Object)existingStrategy.getType())) {
                    log.error("Attempt to change strategy type from {} to {} for strategy {}", (Object)existingStrategy.getType(), (Object)update.getType(), (Object)update.getId());
                    throw new IllegalArgumentException("Cannot change strategy type from " + String.valueOf(existingStrategy.getType()) + " to " + String.valueOf(update.getType()) + " for strategy " + update.getId());
                }
                if (update.getEnabled() != null) {
                    existingStrategy.setEnabled(update.getEnabled());
                }
                if (update.getNamespace() != null) {
                    existingStrategy.setNamespace(update.getNamespace());
                }
                if (update.getStrategyConfig() != null) {
                    existingStrategy.setStrategyConfig(update.getStrategyConfig());
                }
                MemoryStrategy.validate((MemoryStrategy)existingStrategy);
                log.debug("Updated strategy with id: {}", (Object)update.getId());
                continue;
            }
            try {
                MemoryStrategy.validate((MemoryStrategy)update);
            }
            catch (IllegalArgumentException e) {
                log.error("Strategy validation failed for new strategy: {}", (Object)e.getMessage());
                throw e;
            }
            String newId = MemoryStrategy.generateStrategyId((MemoryStrategyType)update.getType());
            update.setId(newId);
            if (update.getEnabled() == null) {
                update.setEnabled(Boolean.valueOf(true));
            }
            strategyMap.put(newId, update);
            log.debug("Added new strategy with id: {}", (Object)newId);
        }
        return new ArrayList<MemoryStrategy>(strategyMap.values());
    }
}

