/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.enhanced.dynamodb.AttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.AttributeValueType;
import software.amazon.awssdk.enhanced.dynamodb.EnhancedType;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.StringConverter;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.TypeConvertingVisitor;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute.EnhancedAttributeValue;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

@SdkInternalApi
@ThreadSafe
@Immutable
public class MapAttributeConverter<T extends Map<?, ?>>
implements AttributeConverter<T> {
    private final Delegate<T, ?, ?> delegate;

    private MapAttributeConverter(Delegate<T, ?, ?> delegate) {
        this.delegate = delegate;
    }

    public static <K, V> MapAttributeConverter<Map<K, V>> mapConverter(StringConverter<K> keyConverter, AttributeConverter<V> valueConverter) {
        return MapAttributeConverter.builder(EnhancedType.mapOf(keyConverter.type(), valueConverter.type())).mapConstructor(LinkedHashMap::new).keyConverter(keyConverter).valueConverter(valueConverter).build();
    }

    public static <K, V> MapAttributeConverter<ConcurrentMap<K, V>> concurrentMapConverter(StringConverter<K> keyConverter, AttributeConverter<V> valueConverter) {
        return MapAttributeConverter.builder(EnhancedType.concurrentMapOf(keyConverter.type(), valueConverter.type())).mapConstructor(ConcurrentHashMap::new).keyConverter(keyConverter).valueConverter(valueConverter).build();
    }

    public static <K, V> MapAttributeConverter<SortedMap<K, V>> sortedMapConverter(StringConverter<K> keyConverter, AttributeConverter<V> valueConverter) {
        return MapAttributeConverter.builder(EnhancedType.sortedMapOf(keyConverter.type(), valueConverter.type())).mapConstructor(TreeMap::new).keyConverter(keyConverter).valueConverter(valueConverter).build();
    }

    public static <K, V> MapAttributeConverter<NavigableMap<K, V>> navigableMapConverter(StringConverter<K> keyConverter, AttributeConverter<V> valueConverter) {
        return MapAttributeConverter.builder(EnhancedType.navigableMapOf(keyConverter.type(), valueConverter.type())).mapConstructor(TreeMap::new).keyConverter(keyConverter).valueConverter(valueConverter).build();
    }

    public static <T extends Map<K, V>, K, V> Builder<T, K, V> builder(EnhancedType<T> mapType) {
        return new Builder(mapType);
    }

    @Override
    public EnhancedType<T> type() {
        return this.delegate.type();
    }

    @Override
    public AttributeValueType attributeValueType() {
        return AttributeValueType.M;
    }

    @Override
    public AttributeValue transformFrom(T input) {
        return this.delegate.toAttributeValue(input).toAttributeValue();
    }

    @Override
    public T transformTo(AttributeValue input) {
        return this.delegate.fromAttributeValue(input);
    }

    @NotThreadSafe
    public static final class Builder<T extends Map<K, V>, K, V> {
        private final EnhancedType<T> mapType;
        private StringConverter<K> keyConverter;
        private AttributeConverter<V> valueConverter;
        private Supplier<? extends T> mapConstructor;

        private Builder(EnhancedType<T> mapType) {
            this.mapType = mapType;
        }

        public Builder<T, K, V> mapConstructor(Supplier<?> mapConstructor) {
            this.mapConstructor = mapConstructor;
            return this;
        }

        public Builder<T, K, V> keyConverter(StringConverter<K> keyConverter) {
            this.keyConverter = keyConverter;
            return this;
        }

        public Builder<T, K, V> valueConverter(AttributeConverter<V> valueConverter) {
            this.valueConverter = valueConverter;
            return this;
        }

        public MapAttributeConverter<T> build() {
            return new MapAttributeConverter(new Delegate(this));
        }
    }

    private static final class Delegate<T extends Map<K, V>, K, V> {
        private final EnhancedType<T> type;
        private final Supplier<? extends T> mapConstructor;
        private final StringConverter<K> keyConverter;
        private final AttributeConverter<V> valueConverter;

        private Delegate(Builder<T, K, V> builder) {
            this.type = ((Builder)builder).mapType;
            this.mapConstructor = ((Builder)builder).mapConstructor;
            this.keyConverter = ((Builder)builder).keyConverter;
            this.valueConverter = ((Builder)builder).valueConverter;
        }

        public EnhancedType<T> type() {
            return this.type;
        }

        public EnhancedAttributeValue toAttributeValue(T input) {
            LinkedHashMap<String, AttributeValue> result = new LinkedHashMap<String, AttributeValue>();
            input.forEach((k, v) -> result.put(this.keyConverter.toString(k), this.valueConverter.transformFrom(v)));
            return EnhancedAttributeValue.fromMap(result);
        }

        public T fromAttributeValue(AttributeValue input) {
            return (T)((Map)EnhancedAttributeValue.fromAttributeValue(input).convert(new TypeConvertingVisitor<T>(Map.class, MapAttributeConverter.class){

                @Override
                public T convertMap(Map<String, AttributeValue> value) {
                    Map result = (Map)mapConstructor.get();
                    value.forEach((k, v) -> result.put(keyConverter.fromString((String)k), valueConverter.transformTo((AttributeValue)v)));
                    return result;
                }
            }));
        }
    }
}

