"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.correlationsSavedObjectType = void 0;
var _common = require("../../common");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

// @experimental This schema is experimental and might change in future releases.
const correlationsSavedObjectType = exports.correlationsSavedObjectType = {
  name: 'correlations',
  hidden: false,
  namespaceType: 'single',
  management: {
    icon: 'link',
    defaultSearchField: 'title',
    importableAndExportable: true,
    getTitle(obj) {
      var _obj$attributes, _obj$attributes2;
      // Use title if available
      if ((_obj$attributes = obj.attributes) !== null && _obj$attributes !== void 0 && _obj$attributes.title) {
        return obj.attributes.title;
      }
      // Fallback for correlations without title (e.g., imported old objects)
      const correlationType = ((_obj$attributes2 = obj.attributes) === null || _obj$attributes2 === void 0 ? void 0 : _obj$attributes2.correlationType) || '';
      if (correlationType.startsWith(_common.CORRELATION_TYPE_PREFIXES.APM_CONFIG)) {
        return 'APM-config';
      }
      if (correlationType.startsWith(_common.CORRELATION_TYPE_PREFIXES.TRACE_TO_LOGS)) {
        // Show full correlationType for unique identification in Assets page
        return correlationType;
      }
      return `Correlation ${obj.id}`;
    },
    getInAppUrl(obj) {
      var _obj$attributes3;
      const correlationType = ((_obj$attributes3 = obj.attributes) === null || _obj$attributes3 === void 0 ? void 0 : _obj$attributes3.correlationType) || '';
      if (correlationType.startsWith(_common.CORRELATION_TYPE_PREFIXES.APM_CONFIG)) {
        return {
          path: '/app/observability-apm-services#/services',
          uiCapabilitiesPath: 'observability.show'
        };
      }
      if (correlationType.startsWith(_common.CORRELATION_TYPE_PREFIXES.TRACE_TO_LOGS)) {
        var _obj$references;
        const traceDatasetId = (_obj$references = obj.references) === null || _obj$references === void 0 || (_obj$references = _obj$references[0]) === null || _obj$references === void 0 ? void 0 : _obj$references.id;
        if (traceDatasetId) {
          return {
            path: `/app/datasets/patterns/${encodeURIComponent(traceDatasetId)}#/?_a=(tab:correlatedDatasets)`,
            uiCapabilitiesPath: 'indexPatterns.save'
          };
        }
      }
      return undefined;
    }
  },
  mappings: {
    properties: {
      title: {
        type: 'text'
      },
      correlationType: {
        type: 'keyword'
      },
      version: {
        type: 'keyword'
      },
      entities: {
        type: 'object',
        enabled: false
      }
    }
  },
  migrations: {}
};