/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.backpressure.settings;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.opensearch.ExceptionsHelper;
import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.search.backpressure.CancellationSettingsListener;
import org.opensearch.search.backpressure.settings.SearchBackpressureSettings;

public class SearchShardTaskSettings {
    private final List<CancellationSettingsListener> listeners = new ArrayList<CancellationSettingsListener>();
    private volatile double cancellationRatio;
    public static final Setting<Double> SETTING_CANCELLATION_RATIO = Setting.doubleSetting("search_backpressure.search_shard_task.cancellation_ratio", SearchBackpressureSettings.SETTING_CANCELLATION_RATIO, value -> {
        if (value <= 0.0) {
            throw new IllegalArgumentException("search_backpressure.search_shard_task.cancellation_ratio must be > 0");
        }
        if (value > 1.0) {
            throw new IllegalArgumentException("search_backpressure.search_shard_task.cancellation_ratio must be <= 1.0");
        }
    }, Setting.Property.Dynamic, Setting.Property.NodeScope);
    private volatile double cancellationRate;
    public static final Setting<Double> SETTING_CANCELLATION_RATE = Setting.doubleSetting("search_backpressure.search_shard_task.cancellation_rate", SearchBackpressureSettings.SETTING_CANCELLATION_RATE, value -> {
        if (value <= 0.0) {
            throw new IllegalArgumentException("search_backpressure.search_shard_task.cancellation_rate must be > 0");
        }
    }, Setting.Property.Dynamic, Setting.Property.NodeScope);
    private volatile double cancellationBurst;
    public static final Setting<Double> SETTING_CANCELLATION_BURST = Setting.doubleSetting("search_backpressure.search_shard_task.cancellation_burst", SearchBackpressureSettings.SETTING_CANCELLATION_BURST, 1.0, Setting.Property.Dynamic, Setting.Property.NodeScope);
    private volatile double totalHeapPercentThreshold;
    public static final Setting<Double> SETTING_TOTAL_HEAP_PERCENT_THRESHOLD = Setting.doubleSetting("search_backpressure.search_shard_task.total_heap_percent_threshold", 0.05, 0.0, 1.0, Setting.Property.Dynamic, Setting.Property.NodeScope);
    private volatile long cpuTimeMillisThreshold;
    public static final Setting<Long> SETTING_CPU_TIME_MILLIS_THRESHOLD = Setting.longSetting("search_backpressure.search_shard_task.cpu_time_millis_threshold", 15000L, 0L, Setting.Property.Dynamic, Setting.Property.NodeScope);
    private volatile long elapsedTimeMillisThreshold;
    public static final Setting<Long> SETTING_ELAPSED_TIME_MILLIS_THRESHOLD = Setting.longSetting("search_backpressure.search_shard_task.elapsed_time_millis_threshold", 30000L, 0L, Setting.Property.Dynamic, Setting.Property.NodeScope);
    private volatile double heapPercentThreshold;
    public static final Setting<Double> SETTING_HEAP_PERCENT_THRESHOLD = Setting.doubleSetting("search_backpressure.search_shard_task.heap_percent_threshold", 0.005, 0.0, 1.0, Setting.Property.Dynamic, Setting.Property.NodeScope);
    private volatile double heapVarianceThreshold;
    public static final Setting<Double> SETTING_HEAP_VARIANCE_THRESHOLD = Setting.doubleSetting("search_backpressure.search_shard_task.heap_variance", 2.0, 0.0, Setting.Property.Dynamic, Setting.Property.NodeScope);
    private volatile int heapMovingAverageWindowSize;
    public static final Setting<Integer> SETTING_HEAP_MOVING_AVERAGE_WINDOW_SIZE = Setting.intSetting("search_backpressure.search_shard_task.heap_moving_average_window_size", 100, 0, Setting.Property.Dynamic, Setting.Property.NodeScope);

    public SearchShardTaskSettings(Settings settings, ClusterSettings clusterSettings) {
        this.totalHeapPercentThreshold = SETTING_TOTAL_HEAP_PERCENT_THRESHOLD.get(settings);
        this.cpuTimeMillisThreshold = SETTING_CPU_TIME_MILLIS_THRESHOLD.get(settings);
        this.elapsedTimeMillisThreshold = SETTING_ELAPSED_TIME_MILLIS_THRESHOLD.get(settings);
        this.heapPercentThreshold = SETTING_HEAP_PERCENT_THRESHOLD.get(settings);
        this.heapVarianceThreshold = SETTING_HEAP_VARIANCE_THRESHOLD.get(settings);
        this.heapMovingAverageWindowSize = SETTING_HEAP_MOVING_AVERAGE_WINDOW_SIZE.get(settings);
        this.cancellationRatio = SETTING_CANCELLATION_RATIO.get(settings);
        this.cancellationRate = SETTING_CANCELLATION_RATE.get(settings);
        this.cancellationBurst = SETTING_CANCELLATION_BURST.get(settings);
        clusterSettings.addSettingsUpdateConsumer(SETTING_TOTAL_HEAP_PERCENT_THRESHOLD, this::setTotalHeapPercentThreshold);
        clusterSettings.addSettingsUpdateConsumer(SETTING_CPU_TIME_MILLIS_THRESHOLD, this::setCpuTimeMillisThreshold);
        clusterSettings.addSettingsUpdateConsumer(SETTING_ELAPSED_TIME_MILLIS_THRESHOLD, this::setElapsedTimeMillisThreshold);
        clusterSettings.addSettingsUpdateConsumer(SETTING_HEAP_PERCENT_THRESHOLD, this::setHeapPercentThreshold);
        clusterSettings.addSettingsUpdateConsumer(SETTING_HEAP_VARIANCE_THRESHOLD, this::setHeapVarianceThreshold);
        clusterSettings.addSettingsUpdateConsumer(SETTING_HEAP_MOVING_AVERAGE_WINDOW_SIZE, this::setHeapMovingAverageWindowSize);
        clusterSettings.addSettingsUpdateConsumer(SETTING_CANCELLATION_RATIO, this::setCancellationRatio);
        clusterSettings.addSettingsUpdateConsumer(SETTING_CANCELLATION_RATE, this::setCancellationRate);
        clusterSettings.addSettingsUpdateConsumer(SETTING_CANCELLATION_BURST, this::setCancellationBurst);
    }

    public double getTotalHeapPercentThreshold() {
        return this.totalHeapPercentThreshold;
    }

    public long getCpuTimeNanosThreshold() {
        return TimeUnit.MILLISECONDS.toNanos(this.cpuTimeMillisThreshold);
    }

    public long getElapsedTimeNanosThreshold() {
        return TimeUnit.MILLISECONDS.toNanos(this.elapsedTimeMillisThreshold);
    }

    public double getHeapPercentThreshold() {
        return this.heapPercentThreshold;
    }

    public double getHeapVarianceThreshold() {
        return this.heapVarianceThreshold;
    }

    public int getHeapMovingAverageWindowSize() {
        return this.heapMovingAverageWindowSize;
    }

    public void setTotalHeapPercentThreshold(double totalHeapPercentThreshold) {
        this.totalHeapPercentThreshold = totalHeapPercentThreshold;
    }

    public void setCpuTimeMillisThreshold(long cpuTimeMillisThreshold) {
        this.cpuTimeMillisThreshold = cpuTimeMillisThreshold;
    }

    public void setElapsedTimeMillisThreshold(long elapsedTimeMillisThreshold) {
        this.elapsedTimeMillisThreshold = elapsedTimeMillisThreshold;
    }

    public void setHeapPercentThreshold(double heapPercentThreshold) {
        this.heapPercentThreshold = heapPercentThreshold;
    }

    public void setHeapVarianceThreshold(double heapVarianceThreshold) {
        this.heapVarianceThreshold = heapVarianceThreshold;
    }

    public void setHeapMovingAverageWindowSize(int heapMovingAverageWindowSize) {
        this.heapMovingAverageWindowSize = heapMovingAverageWindowSize;
    }

    public double getCancellationRatio() {
        return this.cancellationRatio;
    }

    void setCancellationRatio(double cancellationRatio) {
        this.cancellationRatio = cancellationRatio;
        this.notifyListeners(listener -> listener.onRatioChanged(cancellationRatio));
    }

    public double getCancellationRate() {
        return this.cancellationRate;
    }

    public double getCancellationRateNanos() {
        return this.getCancellationRate() / (double)TimeUnit.MILLISECONDS.toNanos(1L);
    }

    void setCancellationRate(double cancellationRate) {
        this.cancellationRate = cancellationRate;
        this.notifyListeners(listener -> listener.onRateChanged(cancellationRate));
    }

    public double getCancellationBurst() {
        return this.cancellationBurst;
    }

    void setCancellationBurst(double cancellationBurst) {
        this.cancellationBurst = cancellationBurst;
        this.notifyListeners(listener -> listener.onBurstChanged(cancellationBurst));
    }

    public void addListener(CancellationSettingsListener listener) {
        this.listeners.add(listener);
    }

    private void notifyListeners(Consumer<CancellationSettingsListener> consumer) {
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        for (CancellationSettingsListener listener : this.listeners) {
            try {
                consumer.accept(listener);
            }
            catch (Exception e) {
                exceptions.add(e);
            }
        }
        ExceptionsHelper.maybeThrowRuntimeAndSuppress(exceptions);
    }

    private static class Defaults {
        private static final double TOTAL_HEAP_PERCENT_THRESHOLD = 0.05;
        private static final long CPU_TIME_MILLIS_THRESHOLD = 15000L;
        private static final long ELAPSED_TIME_MILLIS_THRESHOLD = 30000L;
        private static final double HEAP_PERCENT_THRESHOLD = 0.005;
        private static final double HEAP_VARIANCE_THRESHOLD = 2.0;
        private static final int HEAP_MOVING_AVERAGE_WINDOW_SIZE = 100;

        private Defaults() {
        }
    }
}

