/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.query.support;

import org.apache.lucene.search.MultiTermQuery;
import org.opensearch.common.Nullable;
import org.opensearch.core.ParseField;
import org.opensearch.core.xcontent.DeprecationHandler;

public final class QueryParsers {
    public static final ParseField CONSTANT_SCORE = new ParseField("constant_score", new String[0]);
    public static final ParseField CONSTANT_SCORE_BLENDED = new ParseField("constant_score_blended", new String[0]);
    public static final ParseField SCORING_BOOLEAN = new ParseField("scoring_boolean", new String[0]);
    public static final ParseField CONSTANT_SCORE_BOOLEAN = new ParseField("constant_score_boolean", new String[0]);
    public static final ParseField TOP_TERMS = new ParseField("top_terms_", new String[0]);
    public static final ParseField TOP_TERMS_BOOST = new ParseField("top_terms_boost_", new String[0]);
    public static final ParseField TOP_TERMS_BLENDED_FREQS = new ParseField("top_terms_blended_freqs_", new String[0]);

    private QueryParsers() {
    }

    public static MultiTermQuery.RewriteMethod parseRewriteMethod(@Nullable String rewriteMethod, DeprecationHandler deprecationHandler) {
        return QueryParsers.parseRewriteMethod(rewriteMethod, MultiTermQuery.CONSTANT_SCORE_BLENDED_REWRITE, deprecationHandler);
    }

    public static MultiTermQuery.RewriteMethod parseRewriteMethod(@Nullable String rewriteMethod, @Nullable MultiTermQuery.RewriteMethod defaultRewriteMethod, DeprecationHandler deprecationHandler) {
        if (rewriteMethod == null) {
            return defaultRewriteMethod;
        }
        if (CONSTANT_SCORE.match(rewriteMethod, deprecationHandler)) {
            return MultiTermQuery.CONSTANT_SCORE_REWRITE;
        }
        if (SCORING_BOOLEAN.match(rewriteMethod, deprecationHandler)) {
            return MultiTermQuery.SCORING_BOOLEAN_REWRITE;
        }
        if (CONSTANT_SCORE_BOOLEAN.match(rewriteMethod, deprecationHandler)) {
            return MultiTermQuery.CONSTANT_SCORE_BOOLEAN_REWRITE;
        }
        if (CONSTANT_SCORE_BLENDED.match(rewriteMethod, deprecationHandler)) {
            return MultiTermQuery.CONSTANT_SCORE_BLENDED_REWRITE;
        }
        int firstDigit = -1;
        for (int i = 0; i < rewriteMethod.length(); ++i) {
            if (!Character.isDigit(rewriteMethod.charAt(i))) continue;
            firstDigit = i;
            break;
        }
        if (firstDigit >= 0) {
            int size = Integer.parseInt(rewriteMethod.substring(firstDigit));
            String rewriteMethodName = rewriteMethod.substring(0, firstDigit);
            if (TOP_TERMS.match(rewriteMethodName, deprecationHandler)) {
                return new MultiTermQuery.TopTermsScoringBooleanQueryRewrite(size);
            }
            if (TOP_TERMS_BOOST.match(rewriteMethodName, deprecationHandler)) {
                return new MultiTermQuery.TopTermsBoostOnlyBooleanQueryRewrite(size);
            }
            if (TOP_TERMS_BLENDED_FREQS.match(rewriteMethodName, deprecationHandler)) {
                return new MultiTermQuery.TopTermsBlendedFreqScoringRewrite(size);
            }
        }
        throw new IllegalArgumentException("Failed to parse rewrite_method [" + rewriteMethod + "]");
    }
}

