/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf;

import com.jidesoft.converter.ObjectConverterManager;
import com.jidesoft.plaf.LookAndFeelFactory;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class UIDefaultsLookup {
    private static Logger LOGGER = Logger.getLogger(UIDefaultsLookup.class.getName());
    private static boolean _debug = false;
    private static boolean _trace = false;

    public static void setDebug(boolean debug) {
        _debug = debug;
    }

    public static void setTrace(boolean trace) {
        _trace = trace;
    }

    public static void put(UIDefaults table, String key, Object value) {
        Object cl;
        HashMap v = table.get(key);
        if (v == null || !(v instanceof Map)) {
            v = new HashMap();
            table.put(key, v);
        }
        if (!((cl = UIManager.get("ClassLoader")) instanceof ClassLoader)) {
            cl = value.getClass().getClassLoader();
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Put " + key + " " + value + " using ClassLoader: " + cl);
        }
        ((Map)v).put(cl, value);
    }

    static ClassLoader getCallerClassLoader() {
        Object cl = UIManager.get("ClassLoader");
        if (cl instanceof ClassLoader) {
            return (ClassLoader)cl;
        }
        String className = Thread.currentThread().getStackTrace()[3].getClassName();
        try {
            return Class.forName(className).getClassLoader();
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static Object get(Object key) {
        Object value = UIManager.get(key);
        UIDefaultsLookup.log(value, key, null);
        if (value instanceof Map && "Theme.painter".equals(key)) {
            Object o;
            Map map = (Map)value;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Getting " + key + " from a map");
                for (Object o2 : map.keySet()) {
                    LOGGER.fine("\t" + o2 + " => " + map.get(o2));
                }
            }
            try {
                Object o2;
                ClassLoader classLoader = UIDefaultsLookup.getCallerClassLoader();
                o2 = map.get(classLoader);
                if (o2 != null && LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("\tGetting " + o2 + " using CallerClassLoader" + classLoader);
                }
                while (o2 == null && classLoader.getParent() != null) {
                    o2 = map.get(classLoader = classLoader.getParent());
                    if (o2 == null) continue;
                    if (!LOGGER.isLoggable(Level.FINE)) break;
                    LOGGER.fine("\tGetting " + o2 + " using one of the parent ClassLoader " + classLoader);
                    break;
                }
                if (o2 != null) {
                    return o2;
                }
            }
            catch (Exception classLoader) {
                // empty catch block
            }
            if (map.size() == 1) {
                o = map.values().iterator().next();
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Failed...getting the only one " + o);
                }
                return o;
            }
            o = map.get(LookAndFeelFactory.getUIManagerClassLoader());
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Failed...getting " + o + " using UIManagerClassLoader " + LookAndFeelFactory.getUIManagerClassLoader());
            }
            return o;
        }
        return value;
    }

    public static Object get(Object key, Locale l) {
        Object value = UIManager.get(key, l);
        UIDefaultsLookup.log(value, key, l);
        return value;
    }

    private static void log(Object value, Object key, Locale l) {
        if (_debug && value == null) {
            System.out.println("\"" + key + (l == null ? "" : l.toString()) + " \" ==> null ------------------------");
        } else if (_trace) {
            if (value == null) {
                System.out.println("\"" + key + (l == null ? "" : l.toString()) + " \" ==> null ------------------------");
            } else {
                System.out.println("\"" + key + (l == null ? "" : l.toString()) + " \" ==> " + value.getClass().getName() + "(" + ObjectConverterManager.toString(value) + ")");
            }
        }
    }

    public static Font getFont(Object key) {
        Object value = UIDefaultsLookup.get(key);
        return value instanceof Font ? (Font)value : null;
    }

    public static Font getFont(Object key, Locale l) {
        Object value = UIDefaultsLookup.get(key, l);
        return value instanceof Font ? (Font)value : null;
    }

    public static Color getColor(Object key) {
        Object value = UIDefaultsLookup.get(key);
        return value instanceof Color ? (Color)value : null;
    }

    public static Color getColor(Object key, Locale l) {
        Object value = UIDefaultsLookup.get(key, l);
        return value instanceof Color ? (Color)value : null;
    }

    public static Icon getIcon(Object key) {
        Object value = UIDefaultsLookup.get(key);
        return value instanceof Icon ? (Icon)value : null;
    }

    public static Icon getIcon(Object key, Locale l) {
        Object value = UIDefaultsLookup.get(key, l);
        return value instanceof Icon ? (Icon)value : null;
    }

    public static Border getBorder(Object key) {
        Object value = UIDefaultsLookup.get(key);
        return value instanceof Border ? (Border)value : null;
    }

    public static Border getBorder(Object key, Locale l) {
        Object value = UIDefaultsLookup.get(key, l);
        return value instanceof Border ? (Border)value : null;
    }

    public static String getString(Object key) {
        Object value = UIDefaultsLookup.get(key);
        return value instanceof String ? (String)value : null;
    }

    public static String getString(Object key, Locale l) {
        Object value = UIDefaultsLookup.get(key, l);
        return value instanceof String ? (String)value : null;
    }

    public static int getInt(Object key) {
        Object value = UIDefaultsLookup.get(key);
        return value instanceof Integer ? (Integer)value : 0;
    }

    public static int getInt(Object key, Locale l) {
        Object value = UIDefaultsLookup.get(key, l);
        return value instanceof Integer ? (Integer)value : 0;
    }

    public static boolean getBoolean(Object key) {
        Object value = UIDefaultsLookup.get(key);
        return value instanceof Boolean ? (Boolean)value : false;
    }

    public static boolean getBoolean(Object key, boolean defaultValue) {
        Object value = UIDefaultsLookup.get(key);
        return value instanceof Boolean ? (Boolean)value : defaultValue;
    }

    public static boolean getBoolean(Object key, Locale l) {
        Object value = UIDefaultsLookup.get(key, l);
        return value instanceof Boolean ? (Boolean)value : false;
    }

    public static Insets getInsets(Object key) {
        Object value = UIDefaultsLookup.get(key);
        return value instanceof Insets ? (Insets)value : null;
    }

    public static Insets getInsets(Object key, Locale l) {
        Object value = UIDefaultsLookup.get(key, l);
        return value instanceof Insets ? (Insets)value : null;
    }

    public static Dimension getDimension(Object key) {
        Object value = UIDefaultsLookup.get(key);
        return value instanceof Dimension ? (Dimension)value : null;
    }

    public static Dimension getDimension(Object key, Locale l) {
        Object value = UIDefaultsLookup.get(key, l);
        return value instanceof Dimension ? (Dimension)value : null;
    }
}

