/*
 * Decompiled with CFR 0.152.
 */
package com.github.lgooddatepicker.zinternaltools;

import java.text.DateFormatSymbols;
import java.time.Month;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.TextStyle;
import java.util.ArrayList;
import java.util.Locale;

public class ExtraDateStrings {
    private static final String[] extraParsingFormatsForLanguage_en = new String[]{"M/d/u", "dMMMuu", "dMMMuuuu", "d MMM uu", "d MMM uuuu", "MMM d, u", "MMM d u", "MMM d, yyyy G"};
    private static final String[] extraParsingFormatsForLanguage_ru = new String[]{"d MMM uuuu"};
    public static final String[] monthsNamesForLanguage_ru = new String[]{"\u044f\u043d\u0432\u0430\u0440\u044c", "\u0444\u0435\u0432\u0440\u0430\u043b\u044c", "\u043c\u0430\u0440\u0442", "\u0430\u043f\u0440\u0435\u043b\u044c", "\u043c\u0430\u0439", "\u0438\u044e\u043d\u044c", "\u0438\u044e\u043b\u044c", "\u0430\u0432\u0433\u0443\u0441\u0442", "\u0441\u0435\u043d\u0442\u044f\u0431\u0440\u044c", "\u043e\u043a\u0442\u044f\u0431\u0440\u044c", "\u043d\u043e\u044f\u0431\u0440\u044c", "\u0434\u0435\u043a\u0430\u0431\u0440\u044c"};

    public static ArrayList<DateTimeFormatter> getExtraParsingFormatsForLocale(Locale locale) {
        String language = locale.getLanguage();
        String[] definedFormats = null;
        if ("en".equals(language)) {
            definedFormats = extraParsingFormatsForLanguage_en;
        }
        if ("ru".equals(language)) {
            definedFormats = extraParsingFormatsForLanguage_ru;
        }
        ArrayList<DateTimeFormatter> extraParsingFormatters = new ArrayList<DateTimeFormatter>();
        if (definedFormats == null) {
            return extraParsingFormatters;
        }
        for (String formatString : definedFormats) {
            DateTimeFormatter formatter = new DateTimeFormatterBuilder().parseLenient().parseCaseInsensitive().appendPattern(formatString).toFormatter(locale);
            extraParsingFormatters.add(formatter);
        }
        return extraParsingFormatters;
    }

    public static String[] getDefaultStandaloneLongMonthNamesForLocale(Locale locale) {
        String[] monthNames = ExtraDateStrings.getStandaloneMonthNamesArray(locale, true, false);
        return monthNames;
    }

    public static String[] getDefaultStandaloneShortMonthNamesForLocale(Locale locale) {
        String[] monthNames = ExtraDateStrings.getStandaloneMonthNamesArray(locale, true, true);
        return monthNames;
    }

    private static String getStandaloneMonthName(Month month, Locale locale, boolean capitalize, boolean shortVersion) {
        String monthNumber;
        TextStyle style = shortVersion ? TextStyle.SHORT_STANDALONE : TextStyle.FULL_STANDALONE;
        String monthName = month.getDisplayName(style, locale);
        if (monthName.equals(monthNumber = "" + month.getValue())) {
            DateFormatSymbols dateSymbols = DateFormatSymbols.getInstance(locale);
            monthName = shortVersion ? dateSymbols.getShortMonths()[month.getValue() - 1] : dateSymbols.getMonths()[month.getValue() - 1];
        }
        if (capitalize && monthName != null && monthName.length() > 0) {
            monthName = monthName.substring(0, 1).toUpperCase(locale) + monthName.substring(1);
        }
        return monthName;
    }

    private static String[] getStandaloneMonthNamesArray(Locale locale, boolean capitalize, boolean shortVersion) {
        Month[] monthEnums = Month.values();
        ArrayList<String> monthNamesArrayList = new ArrayList<String>();
        for (Month monthEnum : monthEnums) {
            monthNamesArrayList.add(ExtraDateStrings.getStandaloneMonthName(monthEnum, locale, capitalize, shortVersion));
        }
        String[] monthNames = monthNamesArrayList.toArray(new String[0]);
        return monthNames;
    }

    private static String getFormattingMonthName(Month month, Locale locale, boolean capitalize, boolean shortVersion) {
        DateFormatSymbols dateSymbols = DateFormatSymbols.getInstance(locale);
        String monthName = shortVersion ? dateSymbols.getShortMonths()[month.getValue() - 1] : dateSymbols.getMonths()[month.getValue() - 1];
        if (capitalize && monthName != null && monthName.length() > 0) {
            monthName = monthName.substring(0, 1).toUpperCase(locale) + monthName.substring(1);
        }
        return monthName;
    }

    public static String[] getFormattingMonthNamesArray(Locale locale, boolean capitalize, boolean shortVersion) {
        Month[] monthEnums = Month.values();
        ArrayList<String> monthNamesArrayList = new ArrayList<String>();
        for (Month monthEnum : monthEnums) {
            monthNamesArrayList.add(ExtraDateStrings.getFormattingMonthName(monthEnum, locale, capitalize, shortVersion));
        }
        String[] monthNames = monthNamesArrayList.toArray(new String[0]);
        return monthNames;
    }
}

