/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.util.Objects;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.kstream.KeyValueMapper;
import org.apache.kafka.streams.processor.api.ContextualProcessor;
import org.apache.kafka.streams.processor.api.Processor;
import org.apache.kafka.streams.processor.api.ProcessorSupplier;
import org.apache.kafka.streams.processor.api.Record;

class KStreamFlatMap<KIn, VIn, KOut, VOut>
implements ProcessorSupplier<KIn, VIn, KOut, VOut> {
    private final KeyValueMapper<? super KIn, ? super VIn, ? extends Iterable<? extends KeyValue<? extends KOut, ? extends VOut>>> mapper;

    KStreamFlatMap(KeyValueMapper<? super KIn, ? super VIn, ? extends Iterable<? extends KeyValue<? extends KOut, ? extends VOut>>> mapper) {
        this.mapper = mapper;
    }

    @Override
    public Processor<KIn, VIn, KOut, VOut> get() {
        return new KStreamFlatMapProcessor();
    }

    private class KStreamFlatMapProcessor
    extends ContextualProcessor<KIn, VIn, KOut, VOut> {
        private KStreamFlatMapProcessor() {
        }

        @Override
        public void process(Record<KIn, VIn> record) {
            Iterable newKeyValues = KStreamFlatMap.this.mapper.apply(record.key(), record.value());
            Objects.requireNonNull(newKeyValues, "The provided KeyValueMapper returned null which is not allowed.");
            for (KeyValue keyValue : newKeyValues) {
                this.context().forward(record.withKey(keyValue.key).withValue(keyValue.value));
            }
        }
    }
}

