/*
 * Decompiled with CFR 0.152.
 */
package org.linuxsampler.lscp;

import org.linuxsampler.lscp.AbstractParameter;
import org.linuxsampler.lscp.LscpException;
import org.linuxsampler.lscp.ParameterType;
import org.linuxsampler.lscp.Parser;

public class BoolListParameter
extends AbstractParameter<Boolean[]> {
    private boolean[] val = null;
    private boolean[] dflt = null;
    private boolean[] possibilities = null;

    public BoolListParameter() {
        this.setType(ParameterType.BOOL_LIST);
        this.setMultiplicity(true);
    }

    public BoolListParameter(String string) {
        this(string, null);
    }

    public BoolListParameter(String string, Boolean[] booleanArray) {
        this();
        this.setName(string);
        this.setValue(booleanArray);
    }

    protected BoolListParameter(String[] stringArray) throws LscpException {
        this();
        this.parseLines(stringArray);
    }

    @Override
    public boolean parse(String string) throws LscpException {
        if (super.parse(string)) {
            return true;
        }
        if (string.startsWith("DEFAULT: ")) {
            string = string.substring("DEFAULT: ".length(), string.length());
            this.setDefault(Parser.parseBoolList(string));
            return true;
        }
        if (string.startsWith("POSSIBILITIES: ")) {
            string = string.substring("POSSIBILITIES: ".length(), string.length());
            String[] stringArray = Parser.parseStringList(string);
            Boolean[][] booleanArrayArray = new Boolean[stringArray.length][];
            for (int i = 0; i < stringArray.length; ++i) {
                booleanArrayArray[i] = Parser.parseBoolList(stringArray[i]);
            }
            this.setPossibilities((T[])booleanArrayArray);
            return true;
        }
        return false;
    }

    @Override
    public void parseValue(String string) {
        this.setValue(Parser.parseBoolList(string));
    }

    @Override
    public String getStringValue() {
        Boolean[] booleanArray = (Boolean[])this.getValue();
        if (booleanArray == null || booleanArray.length == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(booleanArray[0]);
        for (int i = 1; i < booleanArray.length; ++i) {
            stringBuffer.append(',').append(booleanArray[i]);
        }
        return stringBuffer.toString();
    }
}

