---
stage: Security Risk Management
group: Security Insights
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: 脆弱性管理ポリシー
description: GitLabで脆弱性管理ポリシーを定義および適用して、脆弱性を自動的に解決し、トリアージのワークロードを削減し、一貫した修正を確保します
---

{{< details >}}

- プラン: Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

{{< history >}}

- GitLab 17.7で、`vulnerability_management_policy_type`という名前の[フラグ](../../../administration/feature_flags/_index.md)を使用して、プロジェクトのセキュリティポリシーを適用するためのサポートを[導入](https://gitlab.com/groups/gitlab-org/-/epics/5708)しました。デフォルトでは有効になっています。
- GitLab 17.8で、グループレベルのセキュリティポリシーを適用するためのサポートを[導入](https://gitlab.com/groups/gitlab-org/-/epics/15697)しました（`vulnerability_management_policy_type_group`という名前の[フラグ](../../../administration/feature_flags/_index.md)を使用）。デフォルトでは有効になっています。
- GitLab 17.9で[一般提供](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178031)になりました。機能フラグ`vulnerability_management_policy_type`および`vulnerability_management_policy_type_group`は削除されました。

{{< /history >}}

脆弱性管理ポリシーを使用して、検出されなくなった脆弱性を自動的に解決します。これにより、脆弱性のトリアージのワークロードを削減できます。

スキャナーがデフォルトブランチの脆弱性を検出すると、スキャナーはステータスが**トリアージが必要**の脆弱性レコードを作成します。脆弱性が修正された後、次のセキュリティスキャンを実行すると、スキャンによってレコードのアクティビティーログに**検出されませんでした**が追加されますが、レコードのステータスは変更されません。ステータスを**解決済み**に変更するには、[手動](../vulnerabilities/_index.md#change-the-status-of-a-vulnerability)で、または脆弱性管理ポリシーを使用します。

脆弱性管理ポリシーを使用すると、ルールが一貫して適用されます。たとえば、デフォルトブランチで検出されなくなった脆弱性を解決済みとしてマークするポリシーを作成できますが、その対象はSASTによって検出された低リスクの脆弱性のみです。脆弱性管理ポリシーは、ステータスが**トリアージが必要**または**確認済み**の脆弱性にのみ影響します。

脆弱性管理ポリシーは、パイプラインがデフォルトブランチに対して実行されるときに適用されます。同じスキャナーによって検出されなくなり、ポリシーのルールに一致する各脆弱性について:

- 脆弱性レコードのステータスは、**GitLab Security Policy Bot**ユーザーによって**解決済み**に設定されます。
- ステータスの変更に関するメモが、脆弱性のレコードに追加されます。

パイプラインの負荷と時間を制限するために、パイプラインあたり最大1,000個の脆弱性がステータス**解決済み**に設定されます。検出されなくなった脆弱性がすべて**解決済み**とマークされるまで、この処理が各パイプラインで繰り返されます。

## 制限事項 {#restrictions}

- 各ポリシーに最大5つのルールを割り当てることができます。
- 各セキュリティポリシープロジェクトに最大5つの脆弱性管理ポリシーを割り当てることができます。
- シークレット検出スキャンにより、以前検出されたシークレットキーが検出されなくなった場合でも、その脆弱性は自動解決されません。代わりに、削除されたシークレットキーが既に公開されているため、**Needs Triage**（トリアージが必要）のままになります。脆弱性のステータスは、シークレットキーが失効またはローテーションされた後にのみ、手動で解決する必要があります。

## 脆弱性管理ポリシーを作成する {#create-a-vulnerability-management-policy}

特定の基準に一致する脆弱性を自動的に解決する脆弱性管理ポリシーを作成します。

前提要件: 

- デフォルトでは、グループ、サブグループ、またはプロジェクトオーナーのみが、セキュリティポリシープロジェクトを作成または割り当てるために必要な権限を持っています。これは、[カスタムロール](../../custom_roles/_index.md)を使用して変更できます。

脆弱性管理ポリシーを作成するには:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. **セキュリティ** > **ポリシー**に移動します。
1. **新規ポリシー**を選択します。
1. **脆弱性管理ポリシー**で、**ポリシーの選択**を選択します。
1. フィールドに入力し、ポリシーのステータスを**有効**に設定します。
1. **ポリシーの作成**を選択します。
1. マージリクエストをレビューしてマージします。

脆弱性管理ポリシーが作成されると、ポリシールールがデフォルトブランチのパイプラインに適用されます。

## 脆弱性管理ポリシーを編集する {#edit-a-vulnerability-management-policy}

ルールを変更するには、脆弱性管理ポリシーを編集します。

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. **セキュリティ** > **ポリシー**に移動します。
1. ポリシーの行で、**編集**を選択します。
1. ポリシーの詳細を編集します。
1. **変更を保存**を選択します。
1. マージリクエストをレビューしてマージします。

脆弱性管理ポリシーが更新されました。次にパイプラインがデフォルトブランチに対して実行されると、ポリシーのルールが適用されます。

### スキーマ {#schema}

脆弱性管理ポリシーが作成または編集されると、[脆弱性管理ポリシースキーマ](vulnerability_management_policy_schema.md)に対してチェックされ、有効であることが確認されます。
