---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: '機密性の高いシークレットまたはトークンLinearクライアントシークレットまたはID（OAuth 2.0）の公開'
---

## 説明 {#description}

応答本文には、OAuth 2.0 LinearクライアントシークレットまたはIDのパターンに一致するコンテンツが含まれていることが確認されました。クライアントシークレットは、ユーザーがアプリケーションにサインインできるようにする際に使用されます。リクエストされたスコープによっては、悪意のある攻撃者がサービスになりすましてユーザーの情報にアクセスする可能性があります。この値を公開すると、攻撃者がこのトークンによって許可されたすべてのリソースにアクセスできる可能性があります。

## 修正 {#remediation}

漏洩したキーに関するセキュリティインシデントの処理に関する一般的なガイダンスについては、[認証情報のインターネットへの公開](../../../../../security/responding_to_security_incidents.md#credential-exposure-to-public-internet)に関するGitLabドキュメントを参照してください。

Linear OAuth 2.0クライアントシークレットを失効するには:

- <https://linear.app/>でアカウントにサインインします
- 左上隅で組織を選択し、「Preferences」を選択します
- 左側のメニューで、「My Account」の「API」を選択します
- ページの「OAuth Applications」セクションで、識別されたキーを含むアプリケーションを見つけます
- アプリケーション名の右側にある省略記号を選択し、「Manage application」を選択します。「Admin Actions」の横にある「Rotate secret」を選択します
- プロンプトが表示されたら、「Rotate your client secret?」ダイアログで「Rotate」を選択します

詳細については、[OAuth 2.0認証に関するLinearのドキュメント](https://developers.linear.app/docs/oauth/authentication)を参照してください。

## 詳細 {#details}

| ID | 集約 | CWE | 型 | リスク |
|:---|:-----------|:----|:-----|:-----|
| 798.67 | いいえ | 798 | パッシブ | 高 |

## リンク {#links}

- [CWE](https://cwe.mitre.org/data/definitions/798.html)
