/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.preferences;

import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.contentassist.ContentAssistUtils;
import org.jkiss.dbeaver.ui.contentassist.SmartTextContentAdapter;
import org.jkiss.dbeaver.ui.contentassist.StringContentProposalProvider;
import org.jkiss.dbeaver.ui.controls.TextWithOpenFile;
import org.jkiss.dbeaver.ui.preferences.AbstractPrefPage;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.PrefUtils;

public class PrefPageErrorLogs
extends AbstractPrefPage
implements IWorkbenchPreferencePage {
    public static final String PAGE_ID = "org.jkiss.dbeaver.preferences.main.errorLogs";
    private Button logsDebugEnabled;
    private TextWithOpenFile logsDebugLocation;
    private Spinner logFilesMaxSizeSpinner;
    private Spinner logFilesMaxCountSpinner;

    public void init(IWorkbench workbench) {
    }

    @NotNull
    protected Control createPreferenceContent(@NotNull Composite parent) {
        Composite composite = UIUtils.createPlaceholder((Composite)parent, (int)1, (int)5);
        DBPPreferenceStore store = DBWorkbench.getPlatform().getPreferenceStore();
        Composite groupLogs = UIUtils.createTitledComposite((Composite)composite, (String)CoreMessages.pref_page_ui_general_group_debug_logs, (int)2, (int)770);
        this.logsDebugEnabled = UIUtils.createCheckbox((Composite)groupLogs, (String)CoreMessages.pref_page_ui_general_label_enable_debug_logs, (String)CoreMessages.pref_page_ui_general_label_enable_debug_logs_tip, (boolean)store.getBoolean("logs.debug.enabled"), (int)2);
        UIUtils.createControlLabel((Composite)groupLogs, (String)CoreMessages.pref_page_ui_general_label_log_file_location);
        this.logsDebugLocation = new TextWithOpenFile(groupLogs, CoreMessages.pref_page_ui_general_label_open_file_text, new String[]{"*.log", "*.txt"});
        ContentAssistUtils.installContentProposal((Control)this.logsDebugLocation.getTextControl(), (IControlContentAdapter)new SmartTextContentAdapter(), (IContentProposalProvider)new StringContentProposalProvider(new String[]{GeneralUtils.variablePattern((String)"workspace"), GeneralUtils.variablePattern((String)"home")}));
        this.logsDebugLocation.setLayoutData((Object)new GridData(768));
        this.logsDebugLocation.setText(store.getString("logs.debug.location"));
        DBPPreferenceStore preferenceStore = DBWorkbench.getPlatform().getPreferenceStore();
        UIUtils.createControlLabel((Composite)groupLogs, (String)CoreMessages.pref_page_logs_files_max_size_label);
        this.logFilesMaxSizeSpinner = new Spinner(groupLogs, 2048);
        this.logFilesMaxSizeSpinner.setDigits(0);
        this.logFilesMaxSizeSpinner.setIncrement(10);
        this.logFilesMaxSizeSpinner.setMinimum(0);
        this.logFilesMaxSizeSpinner.setMaximum(Integer.MAX_VALUE);
        long bigScriptSize = preferenceStore.getLong("logs.files.output.maxSize");
        this.logFilesMaxSizeSpinner.setSelection((int)(bigScriptSize / 1024L));
        UIUtils.createControlLabel((Composite)groupLogs, (String)CoreMessages.pref_page_logs_files_max_count_label);
        this.logFilesMaxCountSpinner = new Spinner(groupLogs, 2048);
        this.logFilesMaxCountSpinner.setDigits(0);
        this.logFilesMaxCountSpinner.setIncrement(1);
        this.logFilesMaxCountSpinner.setMinimum(0);
        this.logFilesMaxCountSpinner.setMaximum(Integer.MAX_VALUE);
        int debugLogFilesMaxCount = preferenceStore.getInt("logs.files.output.maxCount");
        this.logFilesMaxCountSpinner.setSelection(debugLogFilesMaxCount);
        Label tipLabel = UIUtils.createLabel((Composite)groupLogs, (String)CoreMessages.pref_page_ui_general_label_options_take_effect_after_restart);
        tipLabel.setLayoutData((Object)new GridData(32, 2, false, false, 2, 1));
        return composite;
    }

    protected void performDefaults() {
        DBPPreferenceStore store = DBWorkbench.getPlatform().getPreferenceStore();
        this.logsDebugEnabled.setSelection(store.getDefaultBoolean("logs.debug.enabled"));
        this.logsDebugLocation.setText(store.getDefaultString("logs.debug.location"));
        this.logFilesMaxSizeSpinner.setSelection((int)store.getDefaultLong("logs.files.output.maxSize") / 1024);
        this.logFilesMaxCountSpinner.setSelection(store.getDefaultInt("logs.files.output.maxCount"));
        super.performDefaults();
    }

    public boolean performOk() {
        DBPPreferenceStore store = DBWorkbench.getPlatform().getPreferenceStore();
        store.setValue("logs.debug.enabled", this.logsDebugEnabled.getSelection());
        store.setValue("logs.debug.location", this.logsDebugLocation.getText());
        store.setValue("logs.files.output.maxSize", (long)this.logFilesMaxSizeSpinner.getSelection() * 1024L);
        store.setValue("logs.files.output.maxCount", this.logFilesMaxCountSpinner.getSelection());
        PrefUtils.savePreferenceStore((DBPPreferenceStore)store);
        return super.performOk();
    }
}

