/*
 * Decompiled with CFR 0.152.
 */
package vtk.sample.rendering.annotation;

import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import vtk.vtkActor;
import vtk.vtkCubeAxesActor;
import vtk.vtkDelaunay2D;
import vtk.vtkNativeLibrary;
import vtk.vtkPanel;
import vtk.vtkPoints;
import vtk.vtkPolyData;
import vtk.vtkPolyDataMapper;
import vtk.vtkRenderer;
import vtk.vtkStringArray;

public class LabeledCubeAxesActor {
    public static void main(String[] stringArray) {
        try {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    LabeledCubeAxesActor.createVtkPanel();
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static void createVtkPanel() {
        JFrame jFrame = new JFrame();
        vtkPanel vtkPanel2 = new vtkPanel();
        vtkRenderer vtkRenderer2 = vtkPanel2.GetRenderer();
        vtkPoints vtkPoints2 = LabeledCubeAxesActor.getPoints();
        vtkPolyData vtkPolyData2 = new vtkPolyData();
        vtkPolyData2.SetPoints(vtkPoints2);
        vtkDelaunay2D vtkDelaunay2D2 = new vtkDelaunay2D();
        vtkDelaunay2D2.SetInputData(vtkPolyData2);
        vtkPolyDataMapper vtkPolyDataMapper2 = new vtkPolyDataMapper();
        vtkPolyDataMapper2.SetInputConnection(vtkDelaunay2D2.GetOutputPort());
        vtkActor vtkActor2 = new vtkActor();
        vtkActor2.SetMapper(vtkPolyDataMapper2);
        vtkRenderer2.AddActor(vtkActor2);
        vtkCubeAxesActor vtkCubeAxesActor2 = new vtkCubeAxesActor();
        vtkCubeAxesActor2.SetCamera(vtkRenderer2.GetActiveCamera());
        vtkCubeAxesActor2.SetBounds(vtkPoints2.GetBounds());
        vtkCubeAxesActor2.SetXTitle("Date");
        vtkCubeAxesActor2.SetXAxisMinorTickVisibility(false);
        vtkCubeAxesActor2.SetAxisLabels(0, LabeledCubeAxesActor.getXLabels());
        vtkCubeAxesActor2.SetYTitle("Place");
        vtkCubeAxesActor2.SetYAxisMinorTickVisibility(false);
        vtkCubeAxesActor2.SetAxisLabels(1, LabeledCubeAxesActor.getYLabels());
        vtkCubeAxesActor2.SetZTitle("Value");
        vtkRenderer2.AddActor(vtkCubeAxesActor2);
        vtkRenderer2.ResetCamera();
        jFrame.add(vtkPanel2);
        jFrame.setSize(600, 600);
        vtkPanel2.Render();
        jFrame.setVisible(true);
        vtkPanel2.Render();
    }

    static vtkStringArray getYLabels() {
        vtkStringArray vtkStringArray2 = new vtkStringArray();
        vtkStringArray2.InsertNextValue("A");
        vtkStringArray2.InsertNextValue("B");
        vtkStringArray2.InsertNextValue("C");
        return vtkStringArray2;
    }

    static vtkStringArray getXLabels() {
        vtkStringArray vtkStringArray2 = new vtkStringArray();
        vtkStringArray2.InsertNextValue("Jan");
        vtkStringArray2.InsertNextValue("Feb");
        vtkStringArray2.InsertNextValue("Mar");
        vtkStringArray2.InsertNextValue("Apr");
        vtkStringArray2.InsertNextValue("May");
        vtkStringArray2.InsertNextValue("June");
        return vtkStringArray2;
    }

    static vtkPoints getPoints() {
        vtkPoints vtkPoints2 = new vtkPoints();
        vtkPoints2.InsertNextPoint(0.5, 0.0, 0.0);
        vtkPoints2.InsertNextPoint(1.0, 0.0, 1.0);
        vtkPoints2.InsertNextPoint(2.0, 0.0, 0.4);
        vtkPoints2.InsertNextPoint(3.0, 0.0, 0.5);
        vtkPoints2.InsertNextPoint(0.5, 1.0, 0.3);
        vtkPoints2.InsertNextPoint(1.0, 1.0, 0.3);
        vtkPoints2.InsertNextPoint(2.0, 1.0, 0.8);
        vtkPoints2.InsertNextPoint(3.0, 1.0, 0.6);
        vtkPoints2.InsertNextPoint(0.5, 2.0, 0.5);
        vtkPoints2.InsertNextPoint(1.0, 2.0, 0.8);
        vtkPoints2.InsertNextPoint(2.0, 2.0, 0.3);
        vtkPoints2.InsertNextPoint(3.0, 2.0, 0.4);
        return vtkPoints2;
    }

    static {
        if (!vtkNativeLibrary.LoadAllNativeLibraries()) {
            for (vtkNativeLibrary vtkNativeLibrary2 : vtkNativeLibrary.values()) {
                if (vtkNativeLibrary2.IsLoaded()) continue;
                System.out.println(vtkNativeLibrary2.GetLibraryName() + " not loaded");
            }
        }
        vtkNativeLibrary.DisableOutputWindow(null);
    }
}

