/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.black;

import com.intellij.execution.process.CapturingProcessAdapter;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.TargetProgressIndicator;
import com.intellij.execution.target.TargetedCommandLine;
import com.intellij.execution.target.TargetedCommandLineBuilder;
import com.intellij.execution.target.local.LocalTargetEnvironment;
import com.intellij.execution.target.local.LocalTargetEnvironmentRequest;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Version;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.black.BlackFormatterVersionService;
import com.jetbrains.python.black.BlackFormattingRequest;
import com.jetbrains.python.black.BlackFormattingResponse;
import com.jetbrains.python.black.BlackFormattingServiceKt;
import com.jetbrains.python.black.configuration.BlackFormatterConfiguration;
import com.jetbrains.python.pyi.PyiFileType;
import com.jetbrains.python.run.PythonInterpreterTargetEnvironmentFactory;
import com.jetbrains.python.run.target.HelpersAwareTargetEnvironmentRequest;
import com.jetbrains.python.sdk.InvalidSdkException;
import com.jetbrains.python.sdk.PySdkExtKt;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 '2\u00020\u0001:\u0001'B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u001d\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\rH\u0002J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J5\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001d2\u0006\u0010\u001e\u001a\u00020\u00172\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001f\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a2\u0006\u0004\b \u0010!J\u0018\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u001b2\u0006\u0010%\u001a\u00020&H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/jetbrains/python/black/BlackFormatterExecutor;", "", "project", "Lcom/intellij/openapi/project/Project;", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "blackConfig", "Lcom/jetbrains/python/black/configuration/BlackFormatterConfiguration;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/projectRoots/Sdk;Lcom/jetbrains/python/black/configuration/BlackFormatterConfiguration;)V", "targetEnvironment", "Lcom/intellij/execution/target/TargetEnvironment;", "targetEnvironmentRequest", "Lcom/intellij/execution/target/TargetEnvironmentRequest;", "getBlackFormattingResponse", "Lcom/jetbrains/python/black/BlackFormattingResponse;", "blackFormattingRequest", "Lcom/jetbrains/python/black/BlackFormattingRequest;", "timeout", "Lkotlin/time/Duration;", "getBlackFormattingResponse-HG0u8IE", "(Lcom/jetbrains/python/black/BlackFormattingRequest;J)Lcom/jetbrains/python/black/BlackFormattingResponse;", "buildTargetCommandLine", "Lcom/intellij/execution/target/TargetedCommandLine;", "targetEnvRequest", "configToCmdArguments", "", "", "getFuture", "Ljava/util/concurrent/CompletableFuture;", "targetCMD", "formattingRequest", "getFuture-Wn2Vu4Y", "(Lcom/intellij/execution/target/TargetedCommandLine;Lcom/intellij/execution/target/TargetEnvironment;Lcom/jetbrains/python/black/BlackFormattingRequest;J)Ljava/util/concurrent/CompletableFuture;", "writeToStdinListener", "Lcom/intellij/execution/process/ProcessListener;", "text", "charset", "Ljava/nio/charset/Charset;", "Companion", "intellij.python.community.impl"})
@SourceDebugExtension(value={"SMAP\nBlackFormatterExecutor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BlackFormatterExecutor.kt\ncom/jetbrains/python/black/BlackFormatterExecutor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,185:1\n1#2:186\n1869#3,2:187\n23#4:189\n*S KotlinDebug\n*F\n+ 1 BlackFormatterExecutor.kt\ncom/jetbrains/python/black/BlackFormatterExecutor\n*L\n119#1:187,2\n41#1:189\n*E\n"})
public final class BlackFormatterExecutor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Sdk sdk;
    @NotNull
    private final BlackFormatterConfiguration blackConfig;
    @NotNull
    private TargetEnvironment targetEnvironment;
    @NotNull
    private TargetEnvironmentRequest targetEnvironmentRequest;
    private static final long BLACK_DEFAULT_TIMEOUT = DurationKt.toDuration((int)30000, (DurationUnit)DurationUnit.MILLISECONDS);
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final Version minimalStdinFilenameCompatibleVersion;

    public BlackFormatterExecutor(@NotNull Project project, @NotNull Sdk sdk2, @NotNull BlackFormatterConfiguration blackConfig) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
        Intrinsics.checkNotNullParameter((Object)blackConfig, (String)"blackConfig");
        this.project = project;
        this.sdk = sdk2;
        this.blackConfig = blackConfig;
        switch (WhenMappings.$EnumSwitchMapping$0[this.blackConfig.getExecutionMode().ordinal()]) {
            case 1: {
                this.targetEnvironmentRequest = (TargetEnvironmentRequest)new LocalTargetEnvironmentRequest();
                this.targetEnvironment = (TargetEnvironment)new LocalTargetEnvironment(new LocalTargetEnvironmentRequest());
                break;
            }
            case 2: {
                if (!this.sdk.getSdkType().isLocalSdk(this.sdk)) {
                    throw new InvalidSdkException(PyBundle.message("black.remote.sdk.exception.text", new Object[0]));
                }
                HelpersAwareTargetEnvironmentRequest interpreter = PythonInterpreterTargetEnvironmentFactory.Companion.findPythonTargetInterpreter(this.sdk, this.project);
                this.targetEnvironmentRequest = interpreter.getTargetEnvironmentRequest();
                TargetProgressIndicator targetProgressIndicator = TargetProgressIndicator.EMPTY;
                Intrinsics.checkNotNullExpressionValue((Object)targetProgressIndicator, (String)"EMPTY");
                this.targetEnvironment = this.targetEnvironmentRequest.prepareEnvironment(targetProgressIndicator);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    @NotNull
    public final BlackFormattingResponse getBlackFormattingResponse-HG0u8IE(@NotNull BlackFormattingRequest blackFormattingRequest, long l) {
        Intrinsics.checkNotNullParameter((Object)blackFormattingRequest, (String)"blackFormattingRequest");
        TargetedCommandLine targetCMD = this.buildTargetCommandLine(blackFormattingRequest, this.targetEnvironmentRequest);
        CompletableFuture<BlackFormattingResponse> future = this.getFuture-Wn2Vu4Y(targetCMD, this.targetEnvironment, blackFormattingRequest, l);
        Object object = ProgressIndicatorUtils.awaitWithCheckCanceled((Future)future);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"awaitWithCheckCanceled(...)");
        return (BlackFormattingResponse)object;
    }

    private final TargetedCommandLine buildTargetCommandLine(BlackFormattingRequest blackFormattingRequest, TargetEnvironmentRequest targetEnvRequest) {
        VirtualFile cwd;
        VirtualFile virtualFile;
        TargetedCommandLineBuilder cmd = new TargetedCommandLineBuilder(targetEnvRequest);
        List<String> cmdArgs = this.configToCmdArguments(blackFormattingRequest);
        VirtualFile it = virtualFile = blackFormattingRequest.getVirtualFile().getParent();
        boolean bl = false;
        Object object = cwd = it != null && it.isDirectory() ? virtualFile : null;
        if (cwd != null) {
            String string = cwd.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            cmd.setWorkingDirectory(string);
        }
        switch (WhenMappings.$EnumSwitchMapping$0[this.blackConfig.getExecutionMode().ordinal()]) {
            case 1: {
                String blackExecutable = this.blackConfig.getPathToExecutable();
                if (blackExecutable == null) {
                    throw new FileNotFoundException(PyBundle.message("black.empty.path.to.executable.exception.text", new Object[0]));
                }
                cmd.setExePath(blackExecutable);
                break;
            }
            case 2: {
                PySdkExtKt.configureBuilderToRunPythonOnTarget(this.sdk, cmd);
                String[] stringArray = new String[]{"-m", "black"};
                cmd.addParameters(stringArray);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        cmd.addParameters(cmdArgs);
        cmd.addParameter("-");
        return cmd.build();
    }

    private final List<String> configToCmdArguments(BlackFormattingRequest blackFormattingRequest) {
        List cmd = new ArrayList();
        Version blackVersion2 = (Version)CoroutinesKt.runBlockingCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Version>, Object>(this, null){
            int label;
            final /* synthetic */ BlackFormatterExecutor this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = BlackFormatterVersionService.Companion.getVersion(BlackFormatterExecutor.access$getProject$p(this.this$0), (Continuation<? super Version>)((Continuation)this));
                        if (object2 != object) return object2;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return object2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Version> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
        if (FileTypeRegistry.getInstance().isFileOfType(blackFormattingRequest.getVirtualFile(), (FileType)PyiFileType.INSTANCE)) {
            cmd.add("--pyi");
        }
        if (((CharSequence)this.blackConfig.getCmdArguments()).length() > 0) {
            String[] stringArray = new String[]{" "};
            cmd.addAll(StringsKt.split$default((CharSequence)this.blackConfig.getCmdArguments(), (String[])stringArray, (boolean)false, (int)0, (int)6, null));
        }
        if (blackVersion2.compareTo(minimalStdinFilenameCompatibleVersion) >= 0) {
            cmd.add("--stdin-filename");
            String string = blackFormattingRequest.getVirtualFile().getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            cmd.add(string);
        }
        if (blackFormattingRequest instanceof BlackFormattingRequest.Fragment) {
            Iterable $this$forEach$iv = ((BlackFormattingRequest.Fragment)blackFormattingRequest).getLineRanges();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                IntRange range = (IntRange)element$iv;
                boolean bl = false;
                cmd.add("--line-ranges=" + range.getFirst() + "-" + range.getLast());
            }
        }
        return cmd;
    }

    private final CompletableFuture<BlackFormattingResponse> getFuture-Wn2Vu4Y(TargetedCommandLine targetCMD, TargetEnvironment targetEnvironment2, BlackFormattingRequest formattingRequest, long l) {
        VirtualFile vFile = formattingRequest.getVirtualFile();
        CompletableFuture<BlackFormattingResponse.Failure> completableFuture = new CompletableFuture<BlackFormattingResponse.Failure>();
        Object[] objectArray = new Object[]{vFile.getName()};
        String string = PyBundle.message("black.failed.to.format.on.save.error.label", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        CompletableFuture<BlackFormattingResponse> future = completableFuture.completeOnTimeout(new BlackFormattingResponse.Failure(string, "Timeout exceeded", null), Duration.getInWholeMilliseconds-impl((long)l), TimeUnit.MILLISECONDS);
        Process process2 = TargetEnvironment.createProcess$default((TargetEnvironment)targetEnvironment2, (TargetedCommandLine)targetCMD, null, (int)2, null);
        CapturingProcessHandler processHandler = new CapturingProcessHandler(process2, BlackFormattingServiceKt.getDEFAULT_CHARSET(), targetCMD.getCommandPresentation(targetEnvironment2));
        String string2 = formattingRequest.getDocumentText();
        Charset charset = vFile.getCharset();
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"getCharset(...)");
        processHandler.addProcessListener(this.writeToStdinListener(string2, charset));
        processHandler.addProcessListener((ProcessListener)new CapturingProcessAdapter(future, vFile){
            final /* synthetic */ CompletableFuture<BlackFormattingResponse> $future;
            final /* synthetic */ VirtualFile $vFile;
            {
                this.$future = $future;
                this.$vFile = $vFile;
            }

            public void processTerminated(ProcessEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                int exitCode = event.getExitCode();
                if (exitCode == 0) {
                    String string = this.getOutput().getStdout();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStdout(...)");
                    if (((CharSequence)string).length() == 0) {
                        String string2 = PyBundle.message("black.file.ignored.notification.label", new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                        Object[] objectArray = new Object[]{this.$vFile.getName()};
                        String string3 = PyBundle.message("black.file.ignored.notification.message", objectArray);
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
                        v3 = this.$future.complete(new BlackFormattingResponse.Ignored(string2, string3));
                    } else {
                        String string4 = this.getOutput().getStdout();
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getStdout(...)");
                        v3 = this.$future.complete(new BlackFormattingResponse.Success(string4));
                    }
                } else {
                    Object[] objectArray = new Object[]{this.$vFile.getName()};
                    String string = PyBundle.message("black.failed.to.format.on.save.error.label", objectArray);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                    String string5 = this.getOutput().getStderr();
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getStderr(...)");
                    v3 = this.$future.complete(new BlackFormattingResponse.Failure(string, string5, exitCode));
                }
            }
        });
        processHandler.startNotify();
        Intrinsics.checkNotNull(future);
        return future;
    }

    private final ProcessListener writeToStdinListener(String text, Charset charset) {
        return new ProcessListener(text, charset){
            final /* synthetic */ String $text;
            final /* synthetic */ Charset $charset;
            {
                this.$text = $text;
                this.$charset = $charset;
            }

            public void startNotified(ProcessEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                try {
                    OutputStream processInput = event.getProcessHandler().getProcessInput();
                    if (processInput == null) {
                        return;
                    }
                    byte[] byArray = this.$text.getBytes(this.$charset);
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                    processInput.write(byArray);
                    processInput.close();
                }
                catch (IOException e) {
                    BlackFormatterExecutor.access$getLOG$cp().error((Throwable)e);
                }
            }
        };
    }

    public static final /* synthetic */ Project access$getProject$p(BlackFormatterExecutor $this) {
        return $this.project;
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    static {
        Companion $this$thisLogger$iv = Companion;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        minimalStdinFilenameCompatibleVersion = new Version(21, 4, 0);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/jetbrains/python/black/BlackFormatterExecutor$Companion;", "", "<init>", "()V", "BLACK_DEFAULT_TIMEOUT", "Lkotlin/time/Duration;", "getBLACK_DEFAULT_TIMEOUT-UwyO8pc", "()J", "J", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "minimalStdinFilenameCompatibleVersion", "Lcom/intellij/openapi/util/Version;", "intellij.python.community.impl"})
    public static final class Companion {
        private Companion() {
        }

        public final long getBLACK_DEFAULT_TIMEOUT-UwyO8pc() {
            return BLACK_DEFAULT_TIMEOUT;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BlackFormatterConfiguration.ExecutionMode.values().length];
            try {
                nArray[BlackFormatterConfiguration.ExecutionMode.BINARY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BlackFormatterConfiguration.ExecutionMode.PACKAGE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

