/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.diagnostic.ThreadDumper;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.TestOnlyThreading;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.DumbServiceImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.UnindexedFilesScannerExecutor;
import com.intellij.openapi.util.Disposer;
import com.intellij.testFramework.DumbModeTestUtils;
import com.intellij.testFramework.IndexWaiter;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.util.indexing.UnindexedFilesScannerExecutorImpl;
import com.intellij.util.ui.EDT;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.TimeoutCancellationException;
import kotlinx.coroutines.TimeoutKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\b\u0010\u000b\u001a\u00020\fH\u0002J\b\u0010\r\u001a\u00020\fH\u0002J\u0016\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\tH\u0086@\u00a2\u0006\u0002\u0010\u0010J\u000e\u0010\u0011\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/testFramework/IndexWaiter;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "waitAfterWriteAction", "", "indexWaitingTimeout", "Ljava/time/Duration;", "waitNow", "dispatchAllEventsInIdeEventQueue", "", "shouldWait", "suspendUntilIndexesAreReady", "timeout", "(Ljava/time/Duration;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "waitUntilFinished", "intellij.platform.testFramework"})
@SourceDebugExtension(value={"SMAP\nIndexingTestUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IndexingTestUtil.kt\ncom/intellij/testFramework/IndexWaiter\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,197:1\n23#2:198\n23#2:199\n23#2:200\n23#2:201\n23#2:202\n23#2:203\n23#2:204\n*S KotlinDebug\n*F\n+ 1 IndexingTestUtil.kt\ncom/intellij/testFramework/IndexWaiter\n*L\n94#1:198\n101#1:199\n141#1:200\n160#1:201\n171#1:202\n182#1:203\n188#1:204\n*E\n"})
final class IndexWaiter {
    @NotNull
    private final Project project;

    public IndexWaiter(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    private final void waitAfterWriteAction(java.time.Duration indexWaitingTimeout) {
        if (this.project.isDisposed()) {
            return;
        }
        Disposable disposable = Disposer.newDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
        Disposable listenerDisposable = disposable;
        UnindexedFilesScannerExecutor unindexedFilesScannerExecutor = UnindexedFilesScannerExecutor.Companion.getInstance(this.project);
        Intrinsics.checkNotNull((Object)unindexedFilesScannerExecutor, (String)"null cannot be cast to non-null type com.intellij.openapi.Disposable");
        Disposable parentDisposable = (Disposable)unindexedFilesScannerExecutor;
        Disposer.register((Disposable)parentDisposable, (Disposable)listenerDisposable);
        ApplicationManager.getApplication().addApplicationListener(new ApplicationListener(listenerDisposable, this, indexWaitingTimeout){
            private volatile int nested;
            final /* synthetic */ Disposable $listenerDisposable;
            final /* synthetic */ IndexWaiter this$0;
            final /* synthetic */ java.time.Duration $indexWaitingTimeout;
            {
                this.$listenerDisposable = $listenerDisposable;
                this.this$0 = $receiver;
                this.$indexWaitingTimeout = $indexWaitingTimeout;
                this.nested = 1;
            }

            public void beforeWriteActionStart(Object action) {
                Intrinsics.checkNotNullParameter((Object)action, (String)"action");
                if (!EDT.isCurrentThreadEdt()) {
                    return;
                }
                int n = this.nested;
                this.nested = n + 1;
            }

            public void afterWriteActionFinished(Object action) {
                Intrinsics.checkNotNullParameter((Object)action, (String)"action");
                if (!EDT.isCurrentThreadEdt()) {
                    return;
                }
                int n = this.nested;
                this.nested = n + -1;
                int n2 = n = this.nested >= 0 ? 1 : 0;
                if (_Assertions.ENABLED && n == 0) {
                    boolean bl = false;
                    String string = "We counted more finished write actions than started.";
                    throw new AssertionError((Object)string);
                }
                if (this.nested <= 0) {
                    Disposer.dispose((Disposable)this.$listenerDisposable);
                    IndexWaiter.access$waitNow(this.this$0, this.$indexWaitingTimeout);
                }
            }
        }, listenerDisposable);
    }

    private final void waitNow(java.time.Duration indexWaitingTimeout) {
        IndexWaiter $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(IndexWaiter.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.debug("waitNow, thread=" + Thread.currentThread());
        Assert.assertFalse((String)"Should not be invoked from write action", (boolean)ApplicationManager.getApplication().isWriteAccessAllowed());
        if (!this.shouldWait()) {
            return;
        }
        $this$thisLogger$iv = this;
        $i$f$thisLogger = false;
        Logger logger2 = Logger.getInstance(IndexWaiter.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        logger2.debug("waitNow will be waiting, thread=" + Thread.currentThread());
        Application application = ApplicationManager.getApplication();
        if (application.isDispatchThread()) {
            do {
                TestOnlyThreading.releaseTheAcquiredWriteIntentLockThenExecuteActionAndTakeWriteIntentLockBack(() -> IndexWaiter.waitNow$lambda$0(indexWaitingTimeout, this));
            } while (this.dispatchAllEventsInIdeEventQueue());
        } else {
            CoroutinesKt.runBlockingMaybeCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, indexWaitingTimeout, null){
                int label;
                final /* synthetic */ IndexWaiter this$0;
                final /* synthetic */ java.time.Duration $indexWaitingTimeout;
                {
                    this.this$0 = $receiver;
                    this.$indexWaitingTimeout = $indexWaitingTimeout;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = this.this$0.suspendUntilIndexesAreReady(this.$indexWaitingTimeout, (Continuation<? super Unit>)((Continuation)this));
                            if (object2 != object) return Unit.INSTANCE;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
        }
    }

    private final boolean dispatchAllEventsInIdeEventQueue() {
        boolean hasDispatchedEvents = false;
        while (PlatformTestUtil.dispatchNextEventIfAny() != null) {
            hasDispatchedEvents = true;
        }
        return hasDispatchedEvents;
    }

    private final boolean shouldWait() {
        DumbService dumbService = DumbService.Companion.getInstance(this.project);
        Intrinsics.checkNotNull((Object)dumbService, (String)"null cannot be cast to non-null type com.intellij.openapi.project.DumbServiceImpl");
        DumbServiceImpl dumbService2 = (DumbServiceImpl)dumbService;
        dumbService2.ensureInitialDumbTaskRequiredForSmartModeSubmitted();
        UnindexedFilesScannerExecutorImpl scannerExecutor = UnindexedFilesScannerExecutorImpl.Companion.getInstance(this.project);
        if (scannerExecutor.getHasQueuedTasks()) {
            boolean bl;
            if (scannerExecutor.scanningWaitsForNonDumbMode() && dumbService2.isDumb()) {
                boolean isEternal = DumbModeTestUtils.INSTANCE.isEternalDumbTaskRunning$intellij_platform_testFramework(this.project);
                if (isEternal) {
                    IndexWaiter $this$thisLogger$iv = this;
                    boolean $i$f$thisLogger = false;
                    Logger logger = Logger.getInstance(IndexWaiter.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    logger.debug("Do not wait for queued scanning task, because eternal dumb task is running in the project [" + this.project + "]");
                }
                bl = !isEternal;
            } else {
                bl = true;
            }
            return bl;
        }
        if (dumbService2.hasScheduledTasks()) {
            return true;
        }
        if (((Boolean)scannerExecutor.isRunning().getValue()).booleanValue() || dumbService2.isRunning()) {
            return true;
        }
        if (dumbService2.isDumb()) {
            boolean isEternal = DumbModeTestUtils.INSTANCE.isEternalDumbTaskRunning$intellij_platform_testFramework(this.project);
            if (isEternal) {
                IndexWaiter $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(IndexWaiter.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.debug("Do not wait for smart mode, because eternal dumb task is running in the project [" + this.project + "]");
            }
            return !isEternal;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object suspendUntilIndexesAreReady(@NotNull java.time.Duration timeout, @NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof suspendUntilIndexesAreReady.1)) ** GOTO lbl-1000
        var7_3 = $completion;
        if ((var7_3.label & -2147483648) != 0) {
            var7_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ IndexWaiter this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.suspendUntilIndexesAreReady(null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var8_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (this.shouldWait()) {
                    $this$thisLogger$iv = this;
                    $i$f$thisLogger = false;
                    v0 = Logger.getInstance(IndexWaiter.class);
                    Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getInstance(...)");
                    v0.debug("suspendUntilIndexesAreReady will be waiting, thread=" + Thread.currentThread());
                }
                $this$thisLogger$iv = timeout;
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)timeout);
                $continuation.label = 1;
                v1 = TimeoutKt.withTimeout-KLykuaI((long)Duration.plus-LRDsOJo((long)DurationKt.toDuration((long)$this$thisLogger$iv.getSeconds(), (DurationUnit)DurationUnit.SECONDS), (long)DurationKt.toDuration((int)$this$thisLogger$iv.getNano(), (DurationUnit)DurationUnit.NANOSECONDS)), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                    int label;
                    final /* synthetic */ IndexWaiter this$0;
                    {
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    public final Object invokeSuspend(Object $result) {
                        var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
lbl5:
                                // 3 sources

                                while (IndexWaiter.access$shouldWait(this.this$0)) {
                                    this.label = 1;
                                    v0 = DelayKt.delay((long)1L, (Continuation)((Continuation)this));
                                    if (v0 != var2_2) continue;
                                    return var2_2;
                                }
                                break;
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
                                ** GOTO lbl5
                            }
                        }
                        return Unit.INSTANCE;
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                ** if (v1 != var8_5) goto lbl26
lbl25:
                // 1 sources

                return var8_5;
lbl26:
                // 1 sources

                ** GOTO lbl41
            }
            case 1: {
                timeout = (java.time.Duration)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
                }
                catch (TimeoutCancellationException e) {
                    $this$thisLogger$iv = this;
                    $i$f$thisLogger = false;
                    v2 = Logger.getInstance(IndexWaiter.class);
                    Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getInstance(...)");
                    v2.warn(ThreadDumper.dumpThreadsToString(), (Throwable)e);
                    throw e;
                }
lbl41:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public final void waitUntilFinished(@NotNull java.time.Duration indexWaitingTimeout) {
        Intrinsics.checkNotNullParameter((Object)indexWaitingTimeout, (String)"indexWaitingTimeout");
        IndexWaiter $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(IndexWaiter.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.debug("waitUntilFinished, thread=" + Thread.currentThread() + ", WA=" + ApplicationManager.getApplication().isWriteAccessAllowed());
        if (ApplicationManager.getApplication().isWriteAccessAllowed()) {
            this.waitAfterWriteAction(indexWaitingTimeout);
        } else {
            this.waitNow(indexWaitingTimeout);
        }
    }

    private static final Unit waitNow$lambda$0(java.time.Duration $indexWaitingTimeout, IndexWaiter this$0) {
        PlatformTestUtil.waitWithEventsDispatching("Indexing timeout", () -> IndexWaiter.waitNow$lambda$0$0(this$0), (int)$indexWaitingTimeout.getSeconds());
        return Unit.INSTANCE;
    }

    private static final boolean waitNow$lambda$0$0(IndexWaiter this$0) {
        return !this$0.shouldWait();
    }

    public static final /* synthetic */ void access$waitNow(IndexWaiter $this, java.time.Duration indexWaitingTimeout) {
        $this.waitNow(indexWaitingTimeout);
    }

    public static final /* synthetic */ boolean access$shouldWait(IndexWaiter $this) {
        return $this.shouldWait();
    }
}

