/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.vcsUtil.VcsUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangesBrowserModuleNode
extends ChangesBrowserNode<Module>
implements ChangesBrowserNode.NodeWithFilePath {
    @NotNull
    private final FilePath myModuleRoot;

    private ChangesBrowserModuleNode(@NotNull Module userObject, @NotNull FilePath moduleRoot) {
        if (userObject == null) {
            ChangesBrowserModuleNode.$$$reportNull$$$0(0);
        }
        if (moduleRoot == null) {
            ChangesBrowserModuleNode.$$$reportNull$$$0(1);
        }
        super((Object)userObject);
        this.myModuleRoot = moduleRoot;
    }

    @Nullable
    public static ChangesBrowserModuleNode create(@NotNull Module module) {
        FilePath moduleRoot;
        if (module == null) {
            ChangesBrowserModuleNode.$$$reportNull$$$0(2);
        }
        if ((moduleRoot = ChangesBrowserModuleNode.getModuleRootFilePath(module)) == null) {
            return null;
        }
        return new ChangesBrowserModuleNode(module, moduleRoot);
    }

    public void render(@NotNull ChangesBrowserNodeRenderer renderer, boolean selected, boolean expanded, boolean hasFocus) {
        Module module;
        if (renderer == null) {
            ChangesBrowserModuleNode.$$$reportNull$$$0(3);
        }
        renderer.append((module = (Module)this.userObject).isDisposed() ? "" : module.getName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        this.appendCount((ColoredTreeCellRenderer)renderer);
        this.appendParentPath(renderer, this.myModuleRoot);
        if (module.isDisposed()) {
            renderer.setIcon(ModuleType.EMPTY.getIcon());
        } else {
            renderer.setIcon(ModuleType.get((Module)module).getIcon());
        }
    }

    @NotNull
    public FilePath getModuleRoot() {
        FilePath filePath = this.myModuleRoot;
        if (filePath == null) {
            ChangesBrowserModuleNode.$$$reportNull$$$0(4);
        }
        return filePath;
    }

    @NotNull
    public FilePath getNodeFilePath() {
        FilePath filePath = this.getModuleRoot();
        if (filePath == null) {
            ChangesBrowserModuleNode.$$$reportNull$$$0(5);
        }
        return filePath;
    }

    public String getTextPresentation() {
        return ((Module)this.getUserObject()).getName();
    }

    public int getSortWeight() {
        return 4;
    }

    public int compareUserObjects(Module o2) {
        return ChangesBrowserModuleNode.compareFileNames((String)((Module)this.getUserObject()).getName(), (String)o2.getName());
    }

    @Nullable
    private static FilePath getModuleRootFilePath(@NotNull Module module) {
        if (module == null) {
            ChangesBrowserModuleNode.$$$reportNull$$$0(6);
        }
        return (FilePath)ReadAction.compute(() -> {
            if (module.isDisposed()) {
                return null;
            }
            VirtualFile[] roots2 = ModuleRootManager.getInstance((Module)module).getContentRoots();
            if (roots2.length == 1) {
                return VcsUtil.getFilePath((VirtualFile)roots2[0]);
            }
            String moduleDirPath = ModuleUtilCore.getModuleDirPath((Module)module);
            if (moduleDirPath.isEmpty()) {
                return null;
            }
            return VcsUtil.getFilePath((String)moduleDirPath, (boolean)true);
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "userObject";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleRoot";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/ui/ChangesBrowserModuleNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/ChangesBrowserModuleNode";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleRoot";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeFilePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "render";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getModuleRootFilePath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5 -> new IllegalStateException(string);
        };
    }
}

