/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.validation;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.python.PyNames;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.highlighting.PyHighlighter;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDecorator;
import com.jetbrains.python.psi.PyElementVisitor;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.validation.PyAnnotationHolder;
import com.jetbrains.python.validation.PyAnnotatorBase;
import org.jetbrains.annotations.NotNull;

public class PyBuiltinHighlightingAnnotator
extends PyAnnotatorBase {
    protected void annotate(@NotNull PsiElement element, @NotNull PyAnnotationHolder holder) {
        if (element == null) {
            PyBuiltinHighlightingAnnotator.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            PyBuiltinHighlightingAnnotator.$$$reportNull$$$0(1);
        }
        element.accept((PsiElementVisitor)new MyVisitor(holder));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/python/validation/PyBuiltinHighlightingAnnotator";
        objectArray[2] = "annotate";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyVisitor
    extends PyElementVisitor {
        @NotNull
        private final PyAnnotationHolder myHolder;

        private MyVisitor(@NotNull PyAnnotationHolder holder) {
            if (holder == null) {
                MyVisitor.$$$reportNull$$$0(0);
            }
            this.myHolder = holder;
        }

        public void visitPyReferenceExpression(@NotNull PyReferenceExpression node) {
            String name;
            if (node == null) {
                MyVisitor.$$$reportNull$$$0(1);
            }
            if ((name = node.getName()) == null) {
                return;
            }
            boolean highlightedAsAttribute = this.highlightAsAttribute((PyQualifiedExpression)node, name);
            if (highlightedAsAttribute) {
                return;
            }
            if ((PyBuiltinCache.isInBuiltins((PyExpression)node) || PyUtil.isPy2ReservedWord(node)) && !(node.getParent() instanceof PyDecorator)) {
                this.myHolder.addHighlightingAnnotation((PsiElement)node, PyHighlighter.PY_BUILTIN_NAME);
            }
        }

        public void visitPyTargetExpression(@NotNull PyTargetExpression node) {
            String name;
            if (node == null) {
                MyVisitor.$$$reportNull$$$0(2);
            }
            if ((name = node.getName()) != null) {
                this.highlightAsAttribute((PyQualifiedExpression)node, name);
            }
        }

        private boolean highlightAsAttribute(@NotNull PyQualifiedExpression node, @NotNull String name) {
            ASTNode tgt;
            ASTNode astNode;
            if (node == null) {
                MyVisitor.$$$reportNull$$$0(3);
            }
            if (name == null) {
                MyVisitor.$$$reportNull$$$0(4);
            }
            LanguageLevel languageLevel = LanguageLevel.forElement((PsiElement)node);
            if ((PyNames.UNDERSCORED_ATTRIBUTES.contains(name) || PyNames.getBuiltinMethods((LanguageLevel)languageLevel).containsKey(name)) && (node.isQualified() || ScopeUtil.getScopeOwner((PsiElement)node) instanceof PyClass) && (astNode = node.getNode()) != null && (tgt = astNode.findChildByType((IElementType)PyTokenTypes.IDENTIFIER)) != null) {
                this.myHolder.addHighlightingAnnotation(tgt, PyHighlighter.PY_PREDEFINED_USAGE);
                return true;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "holder";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/validation/PyBuiltinHighlightingAnnotator$MyVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyReferenceExpression";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyTargetExpression";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "highlightAsAttribute";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

