/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.application.options.editor.WebEditorOptions;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.codeInsight.editorActions.XmlGtTypedHandler;
import com.intellij.lang.ASTNode;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.AbstractFileViewProvider;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.MultiplePsiFilesPerDocumentFileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.xml.util.XmlTagUtil;
import com.intellij.xml.util.XmlUtil;
import org.jetbrains.annotations.NotNull;

public class XmlSlashTypedHandler
extends TypedHandlerDelegate {
    @NotNull
    public TypedHandlerDelegate.Result beforeCharTyped(char c, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile editedFile, @NotNull FileType fileType) {
        if (project == null) {
            XmlSlashTypedHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            XmlSlashTypedHandler.$$$reportNull$$$0(1);
        }
        if (editedFile == null) {
            XmlSlashTypedHandler.$$$reportNull$$$0(2);
        }
        if (fileType == null) {
            XmlSlashTypedHandler.$$$reportNull$$$0(3);
        }
        if (c == '/' && XmlGtTypedHandler.fileContainsXmlLanguage(editedFile)) {
            XmlTag parentTag;
            PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
            PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
            int offset = editor.getCaretModel().getOffset();
            if (file == null) {
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
                if (result == null) {
                    XmlSlashTypedHandler.$$$reportNull$$$0(4);
                }
                return result;
            }
            FileViewProvider provider = file.getViewProvider();
            PsiElement element = provider.findElementAt(offset, XMLLanguage.class);
            if (element instanceof XmlToken) {
                ASTNode parentNode;
                ASTNode child;
                IElementType tokenType = ((XmlToken)element).getTokenType();
                if (tokenType == XmlTokenType.XML_EMPTY_ELEMENT_END && offset == element.getTextOffset()) {
                    editor.getCaretModel().moveToOffset(offset + 1);
                    editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
                    TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
                    if (result == null) {
                        XmlSlashTypedHandler.$$$reportNull$$$0(5);
                    }
                    return result;
                }
                if (tokenType == XmlTokenType.XML_TAG_END && offset == element.getTextOffset() && (child = XmlChildRole.CLOSING_TAG_START_FINDER.findChild(parentNode = element.getParent().getNode())) != null && offset + 1 == child.getTextRange().getStartOffset()) {
                    editor.getDocument().replaceString(offset + 1, parentNode.getTextRange().getEndOffset(), (CharSequence)"");
                }
            }
            CharSequence contents = provider.getContents();
            if (offset > 0 && contents.charAt(offset - 1) == '<' && (parentTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class)) instanceof HtmlTag && element == provider.findElementAt(offset, provider.getBaseLanguage())) {
                ASTNode closingTagName = XmlChildRole.CLOSING_TAG_NAME_FINDER.findChild(parentTag.getNode());
                ASTNode startingTagName = XmlChildRole.START_TAG_NAME_FINDER.findChild(parentTag.getNode());
                if (closingTagName != null && startingTagName != null && startingTagName.getStartOffset() < offset) {
                    if (closingTagName.getStartOffset() - 1 != offset) {
                        int nextCharPos = StringUtil.skipWhitespaceForward((CharSequence)contents, (int)offset);
                        if (nextCharPos > 0 && contents.charAt(nextCharPos) == '>') {
                            editor.getDocument().insertString(offset, (CharSequence)"/");
                        } else {
                            editor.getDocument().insertString(offset, (CharSequence)"/>");
                        }
                    }
                    editor.getCaretModel().moveCaretRelatively(1, 0, false, false, false);
                    TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
                    if (result == null) {
                        XmlSlashTypedHandler.$$$reportNull$$$0(6);
                    }
                    return result;
                }
            }
        }
        TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
        if (result == null) {
            XmlSlashTypedHandler.$$$reportNull$$$0(7);
        }
        return result;
    }

    @NotNull
    public TypedHandlerDelegate.Result charTyped(char c, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile editedFile) {
        if (project == null) {
            XmlSlashTypedHandler.$$$reportNull$$$0(8);
        }
        if (editor == null) {
            XmlSlashTypedHandler.$$$reportNull$$$0(9);
        }
        if (editedFile == null) {
            XmlSlashTypedHandler.$$$reportNull$$$0(10);
        }
        if (!WebEditorOptions.getInstance().isAutoCloseTag()) {
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
            if (result == null) {
                XmlSlashTypedHandler.$$$reportNull$$$0(11);
            }
            return result;
        }
        if (c == '/' && XmlGtTypedHandler.fileContainsXmlLanguage(editedFile)) {
            PsiElement element2;
            XmlTag tag;
            int offset;
            PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
            PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
            if (file == null) {
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
                if (result == null) {
                    XmlSlashTypedHandler.$$$reportNull$$$0(12);
                }
                return result;
            }
            FileViewProvider provider = file.getViewProvider();
            PsiElement element = provider.findElementAt((offset = editor.getCaretModel().getOffset()) - 1, XMLLanguage.class);
            if (element == null) {
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
                if (result == null) {
                    XmlSlashTypedHandler.$$$reportNull$$$0(13);
                }
                return result;
            }
            if (!(element.getLanguage() instanceof XMLLanguage)) {
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
                if (result == null) {
                    XmlSlashTypedHandler.$$$reportNull$$$0(14);
                }
                return result;
            }
            ASTNode prevLeaf = element.getNode();
            if (prevLeaf == null) {
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
                if (result == null) {
                    XmlSlashTypedHandler.$$$reportNull$$$0(15);
                }
                return result;
            }
            String prevLeafText = prevLeaf.getText();
            if ("</".equals(prevLeafText) && prevLeaf.getElementType() == XmlTokenType.XML_END_TAG_START && (tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class)) != null && StringUtil.isNotEmpty((String)tag.getName()) && TreeUtil.findSibling((ASTNode)prevLeaf, (IElementType)XmlTokenType.XML_NAME) == null && TreeUtil.findSibling((ASTNode)prevLeaf, (IElementType)XmlTokenType.XML_TAG_NAME) == null) {
                PsiElement element1;
                if (provider instanceof MultiplePsiFilesPerDocumentFileViewProvider && (element1 = AbstractFileViewProvider.findElementAt((PsiElement)file, (int)(offset - 1))) != null) {
                    XmlTag tag1 = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element1, XmlTag.class);
                    if (XmlSlashTypedHandler.shouldReplace(tag, tag1, offset)) {
                        tag = tag1;
                    } else {
                        tag1 = (XmlTag)PsiTreeUtil.getPrevSiblingOfType((PsiElement)element1.getParent(), XmlTag.class);
                        if (XmlSlashTypedHandler.shouldReplace(tag, tag1, offset)) {
                            tag = tag1;
                        }
                    }
                }
                EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)(tag.getName() + ">"), (boolean)false);
                XmlSlashTypedHandler.autoIndent(editor);
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
                if (result == null) {
                    XmlSlashTypedHandler.$$$reportNull$$$0(16);
                }
                return result;
            }
            if (!"/".equals(prevLeafText.trim())) {
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
                if (result == null) {
                    XmlSlashTypedHandler.$$$reportNull$$$0(17);
                }
                return result;
            }
            while ((prevLeaf = TreeUtil.prevLeaf((ASTNode)prevLeaf)) != null && prevLeaf.getElementType() == XmlTokenType.XML_WHITE_SPACE) {
            }
            if (prevLeaf instanceof OuterLanguageElement) {
                element = file.getViewProvider().findElementAt(offset - 1, file.getLanguage());
                ASTNode aSTNode = prevLeaf = element != null ? element.getNode() : null;
                while ((prevLeaf = TreeUtil.prevLeaf((ASTNode)prevLeaf)) != null && prevLeaf.getElementType() == XmlTokenType.XML_WHITE_SPACE) {
                }
            }
            if (prevLeaf == null) {
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
                if (result == null) {
                    XmlSlashTypedHandler.$$$reportNull$$$0(18);
                }
                return result;
            }
            tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)prevLeaf.getPsi(), XmlTag.class);
            if (tag == null && (tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)(element2 = provider.findElementAt(prevLeaf.getStartOffset(), XMLLanguage.class)), XmlTag.class)) == null) {
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
                if (result == null) {
                    XmlSlashTypedHandler.$$$reportNull$$$0(19);
                }
                return result;
            }
            XmlToken startToken = XmlUtil.getTokenOfType((PsiElement)tag, (IElementType)XmlTokenType.XML_START_TAG_START);
            if (startToken == null || !startToken.getText().equals("<")) {
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
                if (result == null) {
                    XmlSlashTypedHandler.$$$reportNull$$$0(20);
                }
                return result;
            }
            if (XmlUtil.getTokenOfType((PsiElement)tag, (IElementType)XmlTokenType.XML_TAG_END) != null) {
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
                if (result == null) {
                    XmlSlashTypedHandler.$$$reportNull$$$0(21);
                }
                return result;
            }
            if (XmlUtil.getTokenOfType((PsiElement)tag, (IElementType)XmlTokenType.XML_EMPTY_ELEMENT_END) != null) {
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
                if (result == null) {
                    XmlSlashTypedHandler.$$$reportNull$$$0(22);
                }
                return result;
            }
            if (PsiTreeUtil.getParentOfType((PsiElement)element, XmlAttributeValue.class) != null) {
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
                if (result == null) {
                    XmlSlashTypedHandler.$$$reportNull$$$0(23);
                }
                return result;
            }
            EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)">", (boolean)false);
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
            if (result == null) {
                XmlSlashTypedHandler.$$$reportNull$$$0(24);
            }
            return result;
        }
        TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
        if (result == null) {
            XmlSlashTypedHandler.$$$reportNull$$$0(25);
        }
        return result;
    }

    private static boolean shouldReplace(XmlTag tag, XmlTag tag1, int offset) {
        if (tag1 == null || tag1 == tag || tag1.getTextOffset() <= tag.getTextOffset()) {
            return false;
        }
        if (XmlSlashTypedHandler.hasUnclosedParent(tag1)) {
            return true;
        }
        if (XmlUtil.getTokenOfType((PsiElement)tag1, (IElementType)XmlTokenType.XML_EMPTY_ELEMENT_END) != null) {
            return false;
        }
        XmlToken element = XmlTagUtil.getEndTagNameElement((XmlTag)tag1);
        return element != null && element.getTextOffset() > offset;
    }

    private static boolean hasUnclosedParent(XmlTag tag) {
        String name = tag.getName();
        while (tag != null) {
            if (XmlUtil.getTokenOfType((PsiElement)tag, (IElementType)XmlTokenType.XML_EMPTY_ELEMENT_END) == null && XmlTagUtil.getEndTagNameElement((XmlTag)tag) == null && name.equals(tag.getName())) {
                return true;
            }
            tag = tag.getParentTag();
        }
        return false;
    }

    public static void autoIndent(@NotNull Editor editor) {
        Project project;
        if (editor == null) {
            XmlSlashTypedHandler.$$$reportNull$$$0(26);
        }
        if ((project = editor.getProject()) != null) {
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
            Document document = editor.getDocument();
            documentManager.commitDocument(document);
            int lineOffset = document.getLineStartOffset(document.getLineNumber(editor.getCaretModel().getOffset()));
            CodeStyleManager.getInstance((Project)project).adjustLineIndent(document, lineOffset);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 7, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 9: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editedFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/editorActions/XmlSlashTypedHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/editorActions/XmlSlashTypedHandler";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "beforeCharTyped";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "charTyped";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "beforeCharTyped";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "charTyped";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "autoIndent";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 7, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25 -> new IllegalStateException(string);
        };
    }
}

