/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.cache.impl.idCache;

import com.intellij.html.embedding.HtmlRawTextElementType;
import com.intellij.lexer.Lexer;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.cache.impl.BaseFilterLexer;
import com.intellij.psi.impl.cache.impl.OccurrenceConsumer;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlTokenType;

public class XmlFilterLexer
extends BaseFilterLexer {
    public static final TokenSet NO_WORDS_TOKEN_SET = TokenSet.create((IElementType[])new IElementType[]{XmlTokenType.TAG_WHITE_SPACE, TokenType.WHITE_SPACE, XmlTokenType.XML_REAL_WHITE_SPACE, XmlTokenType.XML_EQ, XmlTokenType.XML_ATTRIBUTE_VALUE_START_DELIMITER, XmlTokenType.XML_ATTRIBUTE_VALUE_END_DELIMITER, XmlTokenType.XML_START_TAG_START, XmlTokenType.XML_EMPTY_ELEMENT_END, XmlTokenType.XML_END_TAG_START, XmlTokenType.XML_TAG_END, XmlTokenType.XML_DOCTYPE_END, XmlTokenType.XML_COMMENT_START, XmlTokenType.XML_COMMENT_END, XmlTokenType.XML_PI_START, XmlTokenType.XML_PI_END, XmlTokenType.XML_CDATA_END});

    public XmlFilterLexer(Lexer originalLexer, OccurrenceConsumer table) {
        super(originalLexer, table);
    }

    public void advance() {
        IElementType tokenType = this.myDelegate.getTokenType();
        if (tokenType == XmlTokenType.XML_COMMENT_CHARACTERS) {
            this.scanWordsInToken(2, false, false);
            this.advanceTodoItemCountsInToken();
        }
        if (tokenType == XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN) {
            this.scanWordsInToken(24, true, false);
        } else if (tokenType == XmlTokenType.XML_NAME || tokenType == XmlTokenType.XML_DATA_CHARACTERS) {
            this.scanWordsInToken(24, false, false);
        } else if (tokenType == XmlTokenType.XML_ENTITY_REF_TOKEN || tokenType == XmlTokenType.XML_CHAR_ENTITY_REF) {
            this.scanWordsInToken(1, false, false);
        } else if (tokenType == XmlElementType.XML_TEXT || tokenType instanceof HtmlRawTextElementType) {
            this.scanWordsInToken(24, false, false);
        } else if (tokenType == XmlTokenType.XML_TAG_CHARACTERS) {
            this.scanWordsInToken(24, false, false);
        } else if (!NO_WORDS_TOKEN_SET.contains(tokenType)) {
            this.scanWordsInToken(16, false, false);
        }
        this.myDelegate.advance();
    }
}

