/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.debugger.impl.frontend.actions;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.remoting.ActionRemoteBehaviorSpecification;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorGutter;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.platform.debugger.impl.frontend.actions.CustomQuickEvaluateActionProviderKt;
import com.intellij.platform.debugger.impl.frontend.evaluate.quick.XQuickEvaluateHandler;
import com.intellij.platform.debugger.impl.frontend.evaluate.quick.common.ValueLookupManager;
import com.intellij.xdebugger.impl.evaluate.quick.common.QuickEvaluateHandler;
import com.intellij.xdebugger.impl.evaluate.quick.common.ValueHintType;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class QuickEvaluateAction
extends DumbAwareAction
implements ActionRemoteBehaviorSpecification.Frontend {
    private static final XQuickEvaluateHandler ourXQuickEvaluateHandler = new XQuickEvaluateHandler();

    public void update(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            QuickEvaluateAction.$$$reportNull$$$0(0);
        }
        if ((project = e.getProject()) == null) {
            e.getPresentation().setVisible(!e.isFromContextMenu());
            e.getPresentation().setEnabled(false);
            return;
        }
        boolean enabled = QuickEvaluateAction.isEnabled(project, e);
        if (e.isFromContextMenu()) {
            e.getPresentation().setVisible(enabled);
        }
        e.getPresentation().setEnabled(enabled);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        XQuickEvaluateHandler handler;
        if (e == null) {
            QuickEvaluateAction.$$$reportNull$$$0(1);
        }
        Project project = e.getProject();
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (project == null || editor == null) {
            return;
        }
        LogicalPosition logicalPosition = editor.getCaretModel().getLogicalPosition();
        QuickEvaluateHandler customHandler = CustomQuickEvaluateActionProviderKt.getEnabledCustomQuickEvaluateActionHandler(project, e);
        if (ourXQuickEvaluateHandler.isEnabled(project, e)) {
            handler = ourXQuickEvaluateHandler;
        } else if (customHandler != null) {
            handler = customHandler;
        } else {
            return;
        }
        ValueLookupManager.getInstance(project).showHint(handler, editor, editor.logicalPositionToXY(logicalPosition), null, ValueHintType.MOUSE_CLICK_HINT);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            QuickEvaluateAction.$$$reportNull$$$0(2);
        }
        return actionUpdateThread;
    }

    private static boolean isEnabled(@NotNull Project project, @NotNull AnActionEvent event) {
        Editor editor;
        if (project == null) {
            QuickEvaluateAction.$$$reportNull$$$0(3);
        }
        if (event == null) {
            QuickEvaluateAction.$$$reportNull$$$0(4);
        }
        if ((editor = (Editor)event.getData(CommonDataKeys.EDITOR)) == null) {
            return false;
        }
        if (event.getData(EditorGutter.KEY) != null) {
            return false;
        }
        if (ourXQuickEvaluateHandler.isEnabled(project, event)) {
            return true;
        }
        QuickEvaluateHandler customHandler = CustomQuickEvaluateActionProviderKt.getEnabledCustomQuickEvaluateActionHandler(project, event);
        return customHandler != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/platform/debugger/impl/frontend/actions/QuickEvaluateAction";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/platform/debugger/impl/frontend/actions/QuickEvaluateAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isEnabled";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

