/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.commons.alerting.model;

import java.io.IOException;
import java.time.Instant;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.commons.alerting.alerts.AlertError;
import org.opensearch.commons.alerting.model.ActionRunResult;
import org.opensearch.commons.alerting.model.MonitorRunResultKt;
import org.opensearch.commons.alerting.model.TriggerRunResult;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.script.ScriptException;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u0000 ;2\u00020\u0001:\u0001;B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004BI\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u000e\u0010\t\u001a\n\u0018\u00010\nj\u0004\u0018\u0001`\u000b\u0012\u0014\b\u0002\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000e0\r\u0012\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0010\u00a2\u0006\u0002\u0010\u0011J\n\u0010$\u001a\u0004\u0018\u00010%H\u0016J\t\u0010&\u001a\u00020\u0006H\u00c6\u0003J\t\u0010'\u001a\u00020\bH\u00c6\u0003J\u0011\u0010(\u001a\n\u0018\u00010\nj\u0004\u0018\u0001`\u000bH\u00c6\u0003J\u0015\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000e0\rH\u00c6\u0003J\u000f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00060\u0010H\u00c6\u0003JU\u0010+\u001a\u00020\u00002\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\u0010\b\u0002\u0010\t\u001a\n\u0018\u00010\nj\u0004\u0018\u0001`\u000b2\u0014\b\u0002\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000e0\r2\u000e\b\u0002\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0010H\u00c6\u0001J\u0013\u0010,\u001a\u00020\b2\b\u0010-\u001a\u0004\u0018\u00010.H\u00d6\u0003J\t\u0010/\u001a\u000200H\u00d6\u0001J\u0018\u00101\u001a\u0002022\u0006\u00103\u001a\u0002022\u0006\u00104\u001a\u000205H\u0016J\t\u00106\u001a\u00020\u0006H\u00d6\u0001J\u0010\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:H\u0016R&\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000e0\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\"\u0010\t\u001a\n\u0018\u00010\nj\u0004\u0018\u0001`\u000bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001a\u0010\u0005\u001a\u00020\u0006X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#\u00a8\u0006<"}, d2={"Lorg/opensearch/commons/alerting/model/ChainedAlertTriggerRunResult;", "Lorg/opensearch/commons/alerting/model/TriggerRunResult;", "sin", "Lorg/opensearch/core/common/io/stream/StreamInput;", "(Lorg/opensearch/core/common/io/stream/StreamInput;)V", "triggerName", "", "triggered", "", "error", "Ljava/lang/Exception;", "Lkotlin/Exception;", "actionResults", "", "Lorg/opensearch/commons/alerting/model/ActionRunResult;", "associatedAlertIds", "", "(Ljava/lang/String;ZLjava/lang/Exception;Ljava/util/Map;Ljava/util/Set;)V", "getActionResults", "()Ljava/util/Map;", "setActionResults", "(Ljava/util/Map;)V", "getAssociatedAlertIds", "()Ljava/util/Set;", "getError", "()Ljava/lang/Exception;", "setError", "(Ljava/lang/Exception;)V", "getTriggerName", "()Ljava/lang/String;", "setTriggerName", "(Ljava/lang/String;)V", "getTriggered", "()Z", "setTriggered", "(Z)V", "alertError", "Lorg/opensearch/commons/alerting/alerts/AlertError;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "", "hashCode", "", "internalXContent", "Lorg/opensearch/core/xcontent/XContentBuilder;", "builder", "params", "Lorg/opensearch/core/xcontent/ToXContent$Params;", "toString", "writeTo", "", "out", "Lorg/opensearch/core/common/io/stream/StreamOutput;", "Companion", "common-utils"})
public final class ChainedAlertTriggerRunResult
extends TriggerRunResult {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private String triggerName;
    private boolean triggered;
    @Nullable
    private Exception error;
    @NotNull
    private Map<String, ActionRunResult> actionResults;
    @NotNull
    private final Set<String> associatedAlertIds;

    public ChainedAlertTriggerRunResult(@NotNull String triggerName, boolean triggered, @Nullable Exception error, @NotNull Map<String, ActionRunResult> actionResults, @NotNull Set<String> associatedAlertIds) {
        Intrinsics.checkNotNullParameter((Object)triggerName, (String)"triggerName");
        Intrinsics.checkNotNullParameter(actionResults, (String)"actionResults");
        Intrinsics.checkNotNullParameter(associatedAlertIds, (String)"associatedAlertIds");
        super(triggerName, error);
        this.triggerName = triggerName;
        this.triggered = triggered;
        this.error = error;
        this.actionResults = actionResults;
        this.associatedAlertIds = associatedAlertIds;
    }

    public /* synthetic */ ChainedAlertTriggerRunResult(String string, boolean bl, Exception exception, Map map, Set set, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            map = new LinkedHashMap();
        }
        this(string, bl, exception, map, set);
    }

    @Override
    @NotNull
    public String getTriggerName() {
        return this.triggerName;
    }

    @Override
    public void setTriggerName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.triggerName = string;
    }

    public final boolean getTriggered() {
        return this.triggered;
    }

    public final void setTriggered(boolean bl) {
        this.triggered = bl;
    }

    @Override
    @Nullable
    public Exception getError() {
        return this.error;
    }

    @Override
    public void setError(@Nullable Exception exception) {
        this.error = exception;
    }

    @NotNull
    public final Map<String, ActionRunResult> getActionResults() {
        return this.actionResults;
    }

    public final void setActionResults(@NotNull Map<String, ActionRunResult> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.actionResults = map;
    }

    @NotNull
    public final Set<String> getAssociatedAlertIds() {
        return this.associatedAlertIds;
    }

    public ChainedAlertTriggerRunResult(@NotNull StreamInput sin) throws IOException {
        Intrinsics.checkNotNullParameter((Object)sin, (String)"sin");
        String string = sin.readString();
        Exception exception = sin.readException();
        boolean bl = sin.readBoolean();
        Map map = sin.readMap();
        Intrinsics.checkNotNull((Object)map, (String)"null cannot be cast to non-null type kotlin.collections.MutableMap<kotlin.String, org.opensearch.commons.alerting.model.ActionRunResult>");
        Map map2 = TypeIntrinsics.asMutableMap((Object)map);
        List list = sin.readStringList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"readStringList(...)");
        Set set = CollectionsKt.toSet((Iterable)list);
        Intrinsics.checkNotNull((Object)string);
        this(string, bl, exception, map2, set);
    }

    @Override
    @Nullable
    public AlertError alertError() {
        if (this.getError() != null) {
            Instant instant = Instant.now();
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
            Exception exception = this.getError();
            Intrinsics.checkNotNull((Object)exception);
            return new AlertError(instant, "Failed evaluating trigger:\n" + MonitorRunResultKt.userErrorMessage(exception));
        }
        for (ActionRunResult actionResult : this.actionResults.values()) {
            if (actionResult.getError() == null) continue;
            Instant instant = Instant.now();
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
            return new AlertError(instant, "Failed running action:\n" + MonitorRunResultKt.userErrorMessage(actionResult.getError()));
        }
        return null;
    }

    @Override
    @NotNull
    public XContentBuilder internalXContent(@NotNull XContentBuilder builder, @NotNull ToXContent.Params params) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        if (this.getError() instanceof ScriptException) {
            Exception exception = this.getError();
            Intrinsics.checkNotNull((Object)exception, (String)"null cannot be cast to non-null type org.opensearch.script.ScriptException");
            this.setError(new Exception(((ScriptException)exception).toJsonString(), this.getError()));
        }
        XContentBuilder xContentBuilder = builder.field("triggered", this.triggered);
        Map<String, ActionRunResult> map = this.actionResults;
        Intrinsics.checkNotNull(map, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, org.opensearch.commons.alerting.model.ActionRunResult>");
        XContentBuilder xContentBuilder2 = xContentBuilder.field("action_results", map);
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder2, (String)"field(...)");
        return xContentBuilder2;
    }

    @Override
    public void writeTo(@NotNull StreamOutput out) throws IOException {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        super.writeTo(out);
        out.writeBoolean(this.triggered);
        Map<String, ActionRunResult> map = this.actionResults;
        Intrinsics.checkNotNull(map, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, org.opensearch.commons.alerting.model.ActionRunResult>");
        out.writeMap(map);
        out.writeStringCollection((Collection)this.associatedAlertIds);
    }

    @NotNull
    public final String component1() {
        return this.triggerName;
    }

    public final boolean component2() {
        return this.triggered;
    }

    @Nullable
    public final Exception component3() {
        return this.error;
    }

    @NotNull
    public final Map<String, ActionRunResult> component4() {
        return this.actionResults;
    }

    @NotNull
    public final Set<String> component5() {
        return this.associatedAlertIds;
    }

    @NotNull
    public final ChainedAlertTriggerRunResult copy(@NotNull String triggerName, boolean triggered, @Nullable Exception error, @NotNull Map<String, ActionRunResult> actionResults, @NotNull Set<String> associatedAlertIds) {
        Intrinsics.checkNotNullParameter((Object)triggerName, (String)"triggerName");
        Intrinsics.checkNotNullParameter(actionResults, (String)"actionResults");
        Intrinsics.checkNotNullParameter(associatedAlertIds, (String)"associatedAlertIds");
        return new ChainedAlertTriggerRunResult(triggerName, triggered, error, actionResults, associatedAlertIds);
    }

    public static /* synthetic */ ChainedAlertTriggerRunResult copy$default(ChainedAlertTriggerRunResult chainedAlertTriggerRunResult, String string, boolean bl, Exception exception, Map map, Set set, int n, Object object) {
        if ((n & 1) != 0) {
            string = chainedAlertTriggerRunResult.triggerName;
        }
        if ((n & 2) != 0) {
            bl = chainedAlertTriggerRunResult.triggered;
        }
        if ((n & 4) != 0) {
            exception = chainedAlertTriggerRunResult.error;
        }
        if ((n & 8) != 0) {
            map = chainedAlertTriggerRunResult.actionResults;
        }
        if ((n & 0x10) != 0) {
            set = chainedAlertTriggerRunResult.associatedAlertIds;
        }
        return chainedAlertTriggerRunResult.copy(string, bl, exception, map, set);
    }

    @NotNull
    public String toString() {
        return "ChainedAlertTriggerRunResult(triggerName=" + this.triggerName + ", triggered=" + this.triggered + ", error=" + this.error + ", actionResults=" + this.actionResults + ", associatedAlertIds=" + this.associatedAlertIds + ")";
    }

    public int hashCode() {
        int result = this.triggerName.hashCode();
        result = result * 31 + Boolean.hashCode(this.triggered);
        result = result * 31 + (this.error == null ? 0 : this.error.hashCode());
        result = result * 31 + ((Object)this.actionResults).hashCode();
        result = result * 31 + ((Object)this.associatedAlertIds).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ChainedAlertTriggerRunResult)) {
            return false;
        }
        ChainedAlertTriggerRunResult chainedAlertTriggerRunResult = (ChainedAlertTriggerRunResult)other;
        if (!Intrinsics.areEqual((Object)this.triggerName, (Object)chainedAlertTriggerRunResult.triggerName)) {
            return false;
        }
        if (this.triggered != chainedAlertTriggerRunResult.triggered) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.error, (Object)chainedAlertTriggerRunResult.error)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.actionResults, chainedAlertTriggerRunResult.actionResults)) {
            return false;
        }
        return Intrinsics.areEqual(this.associatedAlertIds, chainedAlertTriggerRunResult.associatedAlertIds);
    }

    @JvmStatic
    @NotNull
    public static final TriggerRunResult readFrom(@NotNull StreamInput sin) throws IOException {
        return Companion.readFrom(sin);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lorg/opensearch/commons/alerting/model/ChainedAlertTriggerRunResult$Companion;", "", "()V", "readFrom", "Lorg/opensearch/commons/alerting/model/TriggerRunResult;", "sin", "Lorg/opensearch/core/common/io/stream/StreamInput;", "common-utils"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final TriggerRunResult readFrom(@NotNull StreamInput sin) throws IOException {
            Intrinsics.checkNotNullParameter((Object)sin, (String)"sin");
            return new ChainedAlertTriggerRunResult(sin);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

