/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.utils;

import java.net.IDN;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.keycloak.Config;

public class EmailValidationUtil {
    public static final int MAX_LOCAL_PART_LENGTH = 64;
    private static final String LOCAL_PART_ATOM = "[a-z0-9!#$%&'*+/=?^_`{|}~\u0080-\uffff-]";
    private static final String LOCAL_PART_INSIDE_QUOTES_ATOM = "(?:[a-z0-9!#$%&'*.(),<>\\[\\]:;  @+/=?^_`{|}~\u0080-\uffff-]|\\\\\\\\|\\\\\\\")";
    private static final Pattern LOCAL_PART_PATTERN = Pattern.compile("(?:[a-z0-9!#$%&'*+/=?^_`{|}~\u0080-\uffff-]+|\"(?:[a-z0-9!#$%&'*.(),<>\\[\\]:;  @+/=?^_`{|}~\u0080-\uffff-]|\\\\\\\\|\\\\\\\")+\")(?:\\.(?:[a-z0-9!#$%&'*+/=?^_`{|}~\u0080-\uffff-]+|\"(?:[a-z0-9!#$%&'*.(),<>\\[\\]:;  @+/=?^_`{|}~\u0080-\uffff-]|\\\\\\\\|\\\\\\\")+\"))*", 2);
    private static final int MAX_DOMAIN_PART_LENGTH = 255;
    private static final String DOMAIN_CHARS_WITHOUT_DASH = "[a-z\u0080-\uffff0-9!#$%&'*+/=?^`{|}~]";
    private static final String DOMAIN_LABEL = "(?:[a-z\u0080-\uffff0-9!#$%&'*+/=?^`{|}~]-*)*[a-z\u0080-\uffff0-9!#$%&'*+/=?^`{|}~]+";
    private static final String DOMAIN = "(?:[a-z\u0080-\uffff0-9!#$%&'*+/=?^`{|}~]-*)*[a-z\u0080-\uffff0-9!#$%&'*+/=?^`{|}~]++(?:\\.(?:[a-z\u0080-\uffff0-9!#$%&'*+/=?^`{|}~]-*)*[a-z\u0080-\uffff0-9!#$%&'*+/=?^`{|}~]++)*";
    private static final String IP_DOMAIN = "[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}";
    private static final String IP_V6_DOMAIN = "(?:(?:[0-9a-fA-F]{1,4}:){7,7}[0-9a-fA-F]{1,4}|(?:[0-9a-fA-F]{1,4}:){1,7}:|(?:[0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|(?:[0-9a-fA-F]{1,4}:){1,5}(?::[0-9a-fA-F]{1,4}){1,2}|(?:[0-9a-fA-F]{1,4}:){1,4}(?::[0-9a-fA-F]{1,4}){1,3}|(?:[0-9a-fA-F]{1,4}:){1,3}(?::[0-9a-fA-F]{1,4}){1,4}|(?:[0-9a-fA-F]{1,4}:){1,2}(?::[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:(?:(?::[0-9a-fA-F]{1,4}){1,6})|:(?:(?::[0-9a-fA-F]{1,4}){1,7}|:)|fe80:(?::[0-9a-fA-F]{0,4}){0,4}%[0-9a-zA-Z]{1,}|::(?:ffff(:0{1,4}){0,1}:){0,1}(?:(?:25[0-5]|(?:2[0-4]|1{0,1}[0-9]){0,1}[0-9])\\.){3,3}(?:25[0-5]|(?:2[0-4]|1{0,1}[0-9]){0,1}[0-9])|(?:[0-9a-fA-F]{1,4}:){1,4}:(?:(?:25[0-5]|(?:2[0-4]|1{0,1}[0-9]){0,1}[0-9])\\.){3,3}(?:25[0-5]|(?:2[0-4]|1{0,1}[0-9]){0,1}[0-9]))";
    private static final Pattern EMAIL_DOMAIN_PATTERN = Pattern.compile("(?:[a-z\u0080-\uffff0-9!#$%&'*+/=?^`{|}~]-*)*[a-z\u0080-\uffff0-9!#$%&'*+/=?^`{|}~]++(?:\\.(?:[a-z\u0080-\uffff0-9!#$%&'*+/=?^`{|}~]-*)*[a-z\u0080-\uffff0-9!#$%&'*+/=?^`{|}~]++)*|\\[[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\]|\\[IPv6:(?:(?:[0-9a-fA-F]{1,4}:){7,7}[0-9a-fA-F]{1,4}|(?:[0-9a-fA-F]{1,4}:){1,7}:|(?:[0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|(?:[0-9a-fA-F]{1,4}:){1,5}(?::[0-9a-fA-F]{1,4}){1,2}|(?:[0-9a-fA-F]{1,4}:){1,4}(?::[0-9a-fA-F]{1,4}){1,3}|(?:[0-9a-fA-F]{1,4}:){1,3}(?::[0-9a-fA-F]{1,4}){1,4}|(?:[0-9a-fA-F]{1,4}:){1,2}(?::[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:(?:(?::[0-9a-fA-F]{1,4}){1,6})|:(?:(?::[0-9a-fA-F]{1,4}){1,7}|:)|fe80:(?::[0-9a-fA-F]{0,4}){0,4}%[0-9a-zA-Z]{1,}|::(?:ffff(:0{1,4}){0,1}:){0,1}(?:(?:25[0-5]|(?:2[0-4]|1{0,1}[0-9]){0,1}[0-9])\\.){3,3}(?:25[0-5]|(?:2[0-4]|1{0,1}[0-9]){0,1}[0-9])|(?:[0-9a-fA-F]{1,4}:){1,4}:(?:(?:25[0-5]|(?:2[0-4]|1{0,1}[0-9]){0,1}[0-9])\\.){3,3}(?:25[0-5]|(?:2[0-4]|1{0,1}[0-9]){0,1}[0-9]))\\]", 2);
    public static final String MAX_EMAIL_LOCAL_PART_LENGTH = "max-email-local-part-length";

    public static boolean isValidEmail(String value) {
        return EmailValidationUtil.isValidEmail(value, Config.scope((String[])new String[]{"user-profile", "declarative-user-profile"}).getInt(MAX_EMAIL_LOCAL_PART_LENGTH, Integer.valueOf(64)));
    }

    public static boolean isValidEmail(String value, int maxEmailLocalPartLength) {
        if (value == null || value.length() == 0) {
            return false;
        }
        String stringValue = value.toString();
        int splitPosition = stringValue.lastIndexOf(64);
        if (splitPosition < 0) {
            return false;
        }
        String localPart = stringValue.substring(0, splitPosition);
        String domainPart = stringValue.substring(splitPosition + 1);
        if (!EmailValidationUtil.isValidEmailLocalPart(localPart, maxEmailLocalPartLength)) {
            return false;
        }
        return EmailValidationUtil.isValidEmailDomainAddress(domainPart);
    }

    private static boolean isValidEmailLocalPart(String localPart, int maxEmailLocalPartLength) {
        if (localPart.length() > maxEmailLocalPartLength) {
            return false;
        }
        Matcher matcher = LOCAL_PART_PATTERN.matcher(localPart);
        return matcher.matches();
    }

    private static boolean isValidEmailDomainAddress(String domain) {
        String asciiString;
        if (domain.endsWith(".")) {
            return false;
        }
        try {
            asciiString = IDN.toASCII(domain);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        if (asciiString.length() > 255) {
            return false;
        }
        Matcher matcher = EMAIL_DOMAIN_PATTERN.matcher(domain);
        return matcher.matches();
    }
}

