/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage.adapter;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.keycloak.common.util.ObjectUtil;
import org.keycloak.models.GroupModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.RoleUtils;
import org.keycloak.models.utils.UserModelDelegate;

public class UpdateOnlyChangeUserModelDelegate
extends UserModelDelegate {
    public UpdateOnlyChangeUserModelDelegate(UserModel delegate) {
        super(delegate);
    }

    public void setUsername(String username) {
        if (!ObjectUtil.isEqualOrBothNull((Object)this.getUsername(), (Object)username)) {
            this.delegate.setUsername(username);
        }
    }

    public void setEnabled(boolean enabled) {
        if (!ObjectUtil.isEqualOrBothNull((Object)this.isEnabled(), (Object)enabled)) {
            this.delegate.setEnabled(enabled);
        }
    }

    public void setSingleAttribute(String name, String value) {
        if (!ObjectUtil.isEqualOrBothNull((Object)this.getFirstAttribute(name), (Object)value)) {
            this.delegate.setSingleAttribute(name, value);
        }
    }

    public void setAttribute(String name, List<String> values) {
        if (!ObjectUtil.isEqualOrBothNull(this.getAttributeStream(name).collect(Collectors.toList()), values)) {
            this.delegate.setAttribute(name, values);
        }
    }

    public void removeAttribute(String name) {
        if (this.getAttributeStream(name).count() > 0L) {
            this.delegate.removeAttribute(name);
        }
    }

    public void addRequiredAction(String action) {
        if (action != null) {
            if (this.getRequiredActionsStream().noneMatch(action::equals)) {
                this.delegate.addRequiredAction(action);
            }
        }
    }

    public void removeRequiredAction(String action) {
        if (action != null) {
            if (this.getRequiredActionsStream().anyMatch(action::equals)) {
                this.delegate.removeRequiredAction(action);
            }
        }
    }

    public void addRequiredAction(UserModel.RequiredAction action) {
        String actionName = action.name();
        this.addRequiredAction(actionName);
    }

    public void removeRequiredAction(UserModel.RequiredAction action) {
        String actionName = action.name();
        this.removeRequiredAction(actionName);
    }

    public void setFirstName(String firstName) {
        if (!ObjectUtil.isEqualOrBothNull((Object)this.getFirstName(), (Object)firstName)) {
            this.delegate.setFirstName(firstName);
        }
    }

    public void setLastName(String lastName) {
        if (!ObjectUtil.isEqualOrBothNull((Object)this.getLastName(), (Object)lastName)) {
            this.delegate.setLastName(lastName);
        }
    }

    public void setEmail(String email) {
        if (!ObjectUtil.isEqualOrBothNull((Object)this.getEmail(), (Object)email)) {
            this.delegate.setEmail(email);
        }
    }

    public void setEmailVerified(boolean verified) {
        if (!ObjectUtil.isEqualOrBothNull((Object)this.isEmailVerified(), (Object)verified)) {
            this.delegate.setEmailVerified(verified);
        }
    }

    public void grantRole(RoleModel role) {
        if (!this.hasDirectRole(role)) {
            this.delegate.grantRole(role);
        }
    }

    public void deleteRoleMapping(RoleModel role) {
        if (this.hasDirectRole(role)) {
            this.delegate.deleteRoleMapping(role);
        }
    }

    public void setFederationLink(String link) {
        if (!ObjectUtil.isEqualOrBothNull((Object)this.getFederationLink(), (Object)link)) {
            this.delegate.setFederationLink(link);
        }
    }

    public void setServiceAccountClientLink(String clientInternalId) {
        if (!ObjectUtil.isEqualOrBothNull((Object)this.getServiceAccountClientLink(), (Object)clientInternalId)) {
            this.delegate.setServiceAccountClientLink(clientInternalId);
        }
    }

    public void setCreatedTimestamp(Long timestamp) {
        if (!ObjectUtil.isEqualOrBothNull((Object)this.getCreatedTimestamp(), (Object)timestamp)) {
            this.delegate.setCreatedTimestamp(timestamp);
        }
    }

    public void joinGroup(GroupModel group) {
        if (!RoleUtils.isDirectMember((Stream)this.getGroupsStream(), (GroupModel)group)) {
            this.delegate.joinGroup(group);
        }
    }

    public void leaveGroup(GroupModel group) {
        if (RoleUtils.isDirectMember((Stream)this.getGroupsStream(), (GroupModel)group)) {
            this.delegate.leaveGroup(group);
        }
    }
}

