/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.saml.util;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;

public class ArtifactBindingUtils {
    public static String artifactToResolverProviderId(String artifact) {
        return ArtifactBindingUtils.byteArrayToResolverProviderId(Base64.getDecoder().decode(artifact));
    }

    public static String byteArrayToResolverProviderId(byte[] ar) {
        return String.format("%02X%02X", ar[0], ar[1]);
    }

    public static String computeArtifactBindingIdentifierString(String identifierFrom) {
        return Base64.getEncoder().encodeToString(ArtifactBindingUtils.computeArtifactBindingIdentifier(identifierFrom));
    }

    public static String getArtifactBindingIdentifierString(byte[] identifier) {
        return Base64.getEncoder().encodeToString(identifier);
    }

    public static byte[] computeArtifactBindingIdentifier(String identifierFrom) {
        try {
            MessageDigest sha1Digester = MessageDigest.getInstance("SHA-1");
            return sha1Digester.digest(identifierFrom.getBytes(StandardCharsets.UTF_8));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("JVM does not support required cryptography algorithms: SHA-1/SHA1PRNG.", e);
        }
    }
}

