/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.policy;

import org.keycloak.Config;
import org.keycloak.credential.hash.PasswordHashProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.policy.PasswordPolicyConfigException;
import org.keycloak.policy.PasswordPolicyProvider;
import org.keycloak.policy.PasswordPolicyProviderFactory;
import org.keycloak.policy.PolicyError;

public class HashAlgorithmPasswordPolicyProviderFactory
implements PasswordPolicyProviderFactory,
PasswordPolicyProvider {
    private KeycloakSession session;
    private String defaultHashAlgorithm;

    public PasswordPolicyProvider create(KeycloakSession session) {
        this.session = session;
        return this;
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
        this.defaultHashAlgorithm = factory.getProviderFactory(PasswordHashProvider.class).getId();
    }

    public void close() {
    }

    public String getId() {
        return "hashAlgorithm";
    }

    public PolicyError validate(RealmModel realm, UserModel user, String password) {
        return null;
    }

    public PolicyError validate(String user, String password) {
        return null;
    }

    @Override
    public String getDisplayName() {
        return "Hashing Algorithm";
    }

    @Override
    public String getConfigType() {
        return "String";
    }

    @Override
    public String getDefaultConfigValue() {
        return this.defaultHashAlgorithm;
    }

    @Override
    public boolean isMultiplSupported() {
        return false;
    }

    public Object parseConfig(String value) {
        if (value == null) {
            throw new PasswordPolicyConfigException("Password hashing provider id must be set");
        }
        PasswordHashProvider provider = (PasswordHashProvider)this.session.getProvider(PasswordHashProvider.class, value);
        if (provider == null) {
            throw new PasswordPolicyConfigException("Password hashing provider not found");
        }
        return value;
    }
}

