/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.events;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.StatusCode;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.logging.Logger;
import org.keycloak.common.ClientConnection;
import org.keycloak.common.util.Time;
import org.keycloak.events.Event;
import org.keycloak.events.EventListenerProvider;
import org.keycloak.events.EventListenerProviderFactory;
import org.keycloak.events.EventStoreProvider;
import org.keycloak.events.EventType;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.tracing.TracingAttributes;
import org.keycloak.tracing.TracingProvider;

public class EventBuilder {
    private static final Logger log = Logger.getLogger(EventBuilder.class);
    private final KeycloakSession session;
    private EventStoreProvider store;
    private List<EventListenerProvider> listeners;
    private RealmModel realm;
    private Event event;
    private Boolean storeImmediately;
    private final boolean isEventsEnabled;

    public EventBuilder(RealmModel realm, KeycloakSession session, ClientConnection clientConnection) {
        this(realm, session);
        this.ipAddress(clientConnection.getRemoteHost());
    }

    public EventBuilder(RealmModel realm, KeycloakSession session) {
        this.session = session;
        this.realm = realm;
        this.isEventsEnabled = realm.isEventsEnabled();
        this.event = new Event();
        this.store = this.isEventsEnabled ? EventBuilder.getEventStoreProvider(session) : null;
        this.listeners = EventBuilder.getEventListeners(session, realm);
        this.realm(realm);
    }

    private static EventStoreProvider getEventStoreProvider(KeycloakSession session) {
        EventStoreProvider store = (EventStoreProvider)session.getProvider(EventStoreProvider.class);
        if (store == null) {
            log.error((Object)"Events enabled, but no event store provider configured");
        }
        return store;
    }

    private static List<EventListenerProvider> getEventListeners(KeycloakSession session, RealmModel realm) {
        HashSet realmListeners = new HashSet(realm.getEventsListenersStream().toList());
        List<EventListenerProvider> result = session.getKeycloakSessionFactory().getProviderFactoriesStream(EventListenerProvider.class).filter(providerFactory -> realmListeners.contains(providerFactory.getId()) || ((EventListenerProviderFactory)providerFactory).isGlobal()).map(providerFactory -> {
            realmListeners.remove(providerFactory.getId());
            return (EventListenerProvider)session.getProvider(EventListenerProvider.class, providerFactory.getId());
        }).toList();
        if (!realmListeners.isEmpty()) {
            log.error((Object)("Event listeners " + String.valueOf(realmListeners) + " registered, but provider not found"));
        }
        return result;
    }

    private EventBuilder(KeycloakSession session, EventStoreProvider store, List<EventListenerProvider> listeners, RealmModel realm, Event event) {
        this.listeners = listeners;
        this.realm = realm;
        this.event = event;
        this.session = session;
        this.store = store;
        this.isEventsEnabled = realm.isEventsEnabled();
    }

    public EventBuilder realm(RealmModel realm) {
        this.event.setRealmId(realm == null ? null : realm.getId());
        this.event.setRealmName(realm == null ? null : realm.getName());
        return this;
    }

    public EventBuilder client(ClientModel client) {
        this.event.setClientId(client == null ? null : client.getClientId());
        return this;
    }

    public EventBuilder client(String clientId) {
        this.event.setClientId(clientId);
        return this;
    }

    public EventBuilder user(UserModel user) {
        this.event.setUserId(user == null ? null : user.getId());
        return this;
    }

    public EventBuilder user(String userId) {
        this.event.setUserId(userId);
        return this;
    }

    public EventBuilder session(UserSessionModel session) {
        this.event.setSessionId(session == null ? null : session.getId());
        return this;
    }

    public EventBuilder session(String sessionId) {
        this.event.setSessionId(sessionId);
        return this;
    }

    public EventBuilder ipAddress(String ipAddress) {
        this.event.setIpAddress(ipAddress);
        return this;
    }

    public EventBuilder event(EventType e) {
        this.event.setType(e);
        return this;
    }

    public EventBuilder detail(String key, String value) {
        if (value == null || value.equals("")) {
            return this;
        }
        if (this.event.getDetails() == null) {
            this.event.setDetails(new HashMap<String, String>());
        }
        this.event.getDetails().put(key, value);
        return this;
    }

    public EventBuilder detail(String key, Collection<String> values) {
        if (values == null || values.isEmpty()) {
            return this;
        }
        return this.detail(key, values.stream().filter(Objects::nonNull).collect(Collectors.joining("::")));
    }

    public EventBuilder detail(String key, Stream<String> values) {
        if (values == null) {
            return this;
        }
        return this.detail(key, values.filter(Objects::nonNull).collect(Collectors.joining("::")));
    }

    public EventBuilder storeImmediately(boolean forcedValue) {
        this.storeImmediately = forcedValue;
        return this;
    }

    public EventBuilder removeDetail(String key) {
        if (this.event.getDetails() != null) {
            this.event.getDetails().remove(key);
        }
        return this;
    }

    public Event getEvent() {
        return this.event;
    }

    public void success() {
        this.send(this.storeImmediately == null ? false : this.storeImmediately);
    }

    public void error(String error) {
        if (Objects.isNull((Object)this.event.getType())) {
            throw new IllegalStateException("Attempted to define event error without first setting the event type");
        }
        if (!this.event.getType().name().endsWith("_ERROR")) {
            this.event.setType(EventType.valueOf(this.event.getType().name() + "_ERROR"));
        }
        this.event.setError(error);
        this.send(this.storeImmediately == null ? true : this.storeImmediately);
    }

    public EventBuilder clone() {
        return new EventBuilder(this.session, this.store, this.listeners, this.realm, this.event.clone());
    }

    private void send(boolean sendImmediately) {
        this.event.setTime(Time.currentTimeMillis());
        this.event.setId(UUID.randomUUID().toString());
        Set<String> eventTypes = this.realm.getEnabledEventTypesStream().collect(Collectors.toSet());
        if (sendImmediately) {
            KeycloakModelUtils.runJobInTransaction(this.session.getKeycloakSessionFactory(), this.session.getContext(), innerSession -> {
                EventStoreProvider store = this.isEventsEnabled ? EventBuilder.getEventStoreProvider(innerSession) : null;
                List<EventListenerProvider> listeners = EventBuilder.getEventListeners(innerSession, this.realm);
                this.sendNow(store, eventTypes, listeners);
            });
        } else {
            this.sendNow(this.store, eventTypes, this.listeners);
        }
    }

    private void sendNow(EventStoreProvider targetStore, Set<String> eventTypes, List<EventListenerProvider> targetListeners) {
        if (targetStore != null && (eventTypes.isEmpty() && this.event.getType().isSaveByDefault() || eventTypes.contains(this.event.getType().name()))) {
            targetStore.onEvent(this.event);
        }
        this.traceEvent();
        for (EventListenerProvider l : targetListeners) {
            try {
                l.onEvent(this.event);
            }
            catch (Throwable t) {
                log.error((Object)("Failed to send type to " + String.valueOf(l)), t);
            }
        }
    }

    private void traceEvent() {
        TracingProvider tracing = (TracingProvider)this.session.getProvider(TracingProvider.class);
        Span span = tracing.getCurrentSpan();
        if (span.isRecording()) {
            AttributesBuilder ab = Attributes.builder();
            ab.put(TracingAttributes.EVENT_ID, (Object)this.event.getId());
            ab.put(TracingAttributes.REALM_ID, (Object)this.event.getRealmId());
            ab.put(TracingAttributes.REALM_NAME, (Object)this.event.getRealmName());
            ab.put(TracingAttributes.CLIENT_ID, (Object)this.event.getClientId());
            ab.put(TracingAttributes.USER_ID, (Object)this.event.getUserId());
            ab.put(TracingAttributes.SESSION_ID, (Object)this.event.getSessionId());
            ab.put("ipAddress", this.event.getIpAddress());
            ab.put(TracingAttributes.EVENT_ERROR, (Object)this.event.getError());
            Map<String, String> details = this.event.getDetails();
            if (details != null) {
                details.forEach((k, v) -> ab.put("kc.details." + k, v));
            }
            if (this.event.getType().name().endsWith("_ERROR")) {
                span.setStatus(StatusCode.ERROR);
            }
            span.addEvent(this.event.getType().name(), ab.build(), this.event.getTime(), TimeUnit.MILLISECONDS);
        }
    }
}

