/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.broker.provider.util;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import java.util.regex.Pattern;
import org.keycloak.common.util.Base64Url;
import org.keycloak.models.ClientModel;
import org.keycloak.models.RealmModel;

public class IdentityBrokerState {
    private static final Pattern DOT = Pattern.compile("\\.");
    private final String decodedState;
    private final String clientId;
    private final String tabId;
    private final String clientData;
    private final String encoded;

    public static IdentityBrokerState decoded(String state, String clientId, String clientClientId, String tabId, String clientData) {
        String clientIdEncoded = clientClientId;
        boolean isUuid = false;
        if (clientId != null) {
            try {
                UUID clientDbUuid = UUID.fromString(clientId);
                ByteBuffer bb = ByteBuffer.wrap(new byte[16]);
                bb.putLong(clientDbUuid.getMostSignificantBits());
                bb.putLong(clientDbUuid.getLeastSignificantBits());
                byte[] clientUuidBytes = bb.array();
                clientIdEncoded = Base64Url.encode((byte[])clientUuidBytes);
                isUuid = true;
            }
            catch (RuntimeException clientDbUuid) {
                // empty catch block
            }
        }
        if (!isUuid && clientIdEncoded != null) {
            clientIdEncoded = Base64Url.encode((byte[])clientIdEncoded.getBytes(StandardCharsets.UTF_8));
        }
        String encodedState = state + "." + tabId + "." + clientIdEncoded;
        if (clientData != null) {
            encodedState = encodedState + "." + clientData;
        }
        return new IdentityBrokerState(state, clientClientId, tabId, clientData, encodedState);
    }

    public static IdentityBrokerState encoded(String encodedState, RealmModel realmModel) {
        String[] decoded = DOT.split(encodedState, 4);
        String state = decoded.length > 0 ? decoded[0] : null;
        String tabId = decoded.length > 1 ? decoded[1] : null;
        String clientId = decoded.length > 2 ? decoded[2] : null;
        String clientData = decoded.length > 3 ? decoded[3] : null;
        boolean isUuid = false;
        if (clientId != null) {
            try {
                byte[] decodedClientId = Base64Url.decode((String)clientId);
                ByteBuffer bb = ByteBuffer.wrap(decodedClientId);
                long first = bb.getLong();
                long second = bb.getLong();
                UUID clientDbUuid = new UUID(first, second);
                String clientIdInDb = clientDbUuid.toString();
                ClientModel clientModel = realmModel.getClientById(clientIdInDb);
                if (clientModel != null) {
                    clientId = clientModel.getClientId();
                    isUuid = true;
                }
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            if (!isUuid) {
                clientId = new String(Base64Url.decode((String)clientId), StandardCharsets.UTF_8);
            }
        }
        return new IdentityBrokerState(state, clientId, tabId, clientData, encodedState);
    }

    private IdentityBrokerState(String decodedStateParam, String clientId, String tabId, String clientData, String encoded) {
        this.decodedState = decodedStateParam;
        this.clientId = clientId;
        this.tabId = tabId;
        this.clientData = clientData;
        this.encoded = encoded;
    }

    public String getDecodedState() {
        return this.decodedState;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getTabId() {
        return this.tabId;
    }

    public String getClientData() {
        return this.clientData;
    }

    public String getEncoded() {
        return this.encoded;
    }
}

