/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.fgap.evaluation;

import java.util.Map;
import java.util.function.Consumer;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.Decision;
import org.keycloak.authorization.fgap.evaluation.FGAPDecision;
import org.keycloak.authorization.fgap.evaluation.partial.ResourceTypePolicyEvaluator;
import org.keycloak.authorization.fgap.evaluation.partial.UserResourceTypePolicyEvaluator;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.permission.ResourcePermission;
import org.keycloak.authorization.policy.evaluation.DefaultPolicyEvaluator;
import org.keycloak.authorization.policy.evaluation.EvaluationContext;
import org.keycloak.authorization.store.PolicyStore;
import org.keycloak.authorization.store.ResourceStore;
import org.keycloak.authorization.store.StoreFactory;

public final class FGAPPolicyEvaluator
extends DefaultPolicyEvaluator {
    private final Map<String, ? extends ResourceTypePolicyEvaluator> resourceTypePolicyEvaluators = Map.of("Users", new UserResourceTypePolicyEvaluator());

    @Override
    public void evaluate(ResourcePermission permission, AuthorizationProvider authorizationProvider, EvaluationContext executionContext, Decision decision, Map<Policy, Map<Object, Decision.Effect>> decisionCache) {
        super.evaluate(permission, authorizationProvider, executionContext, new FGAPDecision(decision), decisionCache);
    }

    @Override
    protected void evaluateResourcePolicies(ResourcePermission permission, AuthorizationProvider authorization, Consumer<Policy> policyConsumer) {
        super.evaluateResourcePolicies(permission, authorization, policyConsumer);
        String resourceType = permission.getResourceType();
        if (resourceType == null) {
            return;
        }
        ResourceTypePolicyEvaluator resourceTypePolicyEvaluator = this.resourceTypePolicyEvaluators.get(resourceType);
        if (resourceTypePolicyEvaluator == null) {
            return;
        }
        resourceTypePolicyEvaluator.evaluate(permission, authorization, policyConsumer);
    }

    @Override
    protected void evaluateResourceTypePolicies(ResourcePermission permission, AuthorizationProvider authorization, Consumer<Policy> policyConsumer) {
        String resourceType = permission.getResourceType();
        Resource resource = permission.getResource();
        if (resourceType == null || resource.getName().equals(permission.getResourceType())) {
            return;
        }
        StoreFactory storeFactory = authorization.getStoreFactory();
        ResourceStore resourceStore = storeFactory.getResourceStore();
        PolicyStore policyStore = storeFactory.getPolicyStore();
        ResourceServer resourceServer = permission.getResourceServer();
        Resource resourceTypeResource = resourceStore.findByName(resourceServer, resourceType);
        policyStore.findByResource(resourceServer, resourceTypeResource, policyConsumer);
    }

    @Override
    protected void evaluateScopePolicies(ResourcePermission permission, AuthorizationProvider authorization, Consumer<Policy> policyConsumer) {
    }
}

