/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.common.util.reflections;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.HashMap;
import java.util.Map;

public class Types {
    private static final Type[] EMPTY_TYPE_ARRAY = new Type[0];

    private Types() {
    }

    public static Type boxedType(Type type) {
        if (type instanceof Class) {
            return Types.boxedClass((Class)type);
        }
        return type;
    }

    public static Class<?> boxedClass(Class<?> type) {
        if (!type.isPrimitive()) {
            return type;
        }
        if (type.equals(Boolean.TYPE)) {
            return Boolean.class;
        }
        if (type.equals(Character.TYPE)) {
            return Character.class;
        }
        if (type.equals(Byte.TYPE)) {
            return Byte.class;
        }
        if (type.equals(Short.TYPE)) {
            return Short.class;
        }
        if (type.equals(Integer.TYPE)) {
            return Integer.class;
        }
        if (type.equals(Long.TYPE)) {
            return Long.class;
        }
        if (type.equals(Float.TYPE)) {
            return Float.class;
        }
        if (type.equals(Double.TYPE)) {
            return Double.class;
        }
        if (type.equals(Void.TYPE)) {
            return Void.class;
        }
        return type;
    }

    public static boolean isA(Class clazz, ParameterizedType pType) {
        return clazz.isAssignableFrom((Class)pType.getRawType());
    }

    public static Class getArgumentType(ParameterizedType pType, int index) {
        return (Class)pType.getActualTypeArguments()[index];
    }

    public static Class getTemplateParameterOfInterface(Class base, Class desiredInterface) {
        Object rtn = Types.searchForInterfaceTemplateParameter(base, desiredInterface);
        if (rtn != null && rtn instanceof Class) {
            return (Class)rtn;
        }
        return null;
    }

    private static Object searchForInterfaceTemplateParameter(Class base, Class desiredInterface) {
        for (int i = 0; i < base.getInterfaces().length; ++i) {
            Class<?> intf = base.getInterfaces()[i];
            if (!intf.equals(desiredInterface)) continue;
            Type generic = base.getGenericInterfaces()[i];
            if (generic instanceof ParameterizedType) {
                ParameterizedType p = (ParameterizedType)generic;
                Type type = p.getActualTypeArguments()[0];
                Class<?> rtn = Types.getRawTypeNoException(type);
                if (rtn != null) {
                    return rtn;
                }
                return type;
            }
            return null;
        }
        if (base.getSuperclass() == null || base.getSuperclass().equals(Object.class)) {
            return null;
        }
        Object rtn = Types.searchForInterfaceTemplateParameter(base.getSuperclass(), desiredInterface);
        if (rtn == null || rtn instanceof Class) {
            return rtn;
        }
        if (!(rtn instanceof TypeVariable)) {
            return null;
        }
        String name = ((TypeVariable)rtn).getName();
        int index = -1;
        TypeVariable<Class<T>>[] variables = base.getSuperclass().getTypeParameters();
        if (variables == null || variables.length < 1) {
            return null;
        }
        for (int i = 0; i < variables.length; ++i) {
            if (!variables[i].getName().equals(name)) continue;
            index = i;
        }
        if (index == -1) {
            return null;
        }
        Type genericSuperclass = base.getGenericSuperclass();
        if (!(genericSuperclass instanceof ParameterizedType)) {
            return null;
        }
        ParameterizedType pt = (ParameterizedType)genericSuperclass;
        Type type = pt.getActualTypeArguments()[index];
        Class<?> clazz = Types.getRawTypeNoException(type);
        if (clazz != null) {
            return clazz;
        }
        return type;
    }

    public static boolean isCompatible(Method method, Method intfMethod) {
        if (method == intfMethod) {
            return true;
        }
        if (!method.getName().equals(intfMethod.getName())) {
            return false;
        }
        if (method.getParameterCount() != intfMethod.getParameterCount()) {
            return false;
        }
        for (int i = 0; i < method.getParameterCount(); ++i) {
            Class<?> rootParam = method.getParameterTypes()[i];
            Class<?> intfParam = intfMethod.getParameterTypes()[i];
            if (intfParam.isAssignableFrom(rootParam)) continue;
            return false;
        }
        return true;
    }

    public static Method getImplementingMethod(Class clazz, Method intfMethod) {
        Class<?> declaringClass = intfMethod.getDeclaringClass();
        if (declaringClass.equals(clazz)) {
            return intfMethod;
        }
        Class<?>[] paramTypes = intfMethod.getParameterTypes();
        if (declaringClass.getTypeParameters().length > 0 && paramTypes.length > 0) {
            Type[] intfTypes = Types.findParameterizedTypes(clazz, declaringClass);
            HashMap<String, Type> typeVarMap = new HashMap<String, Type>();
            TypeVariable<Class<?>>[] vars = declaringClass.getTypeParameters();
            for (int i = 0; i < vars.length; ++i) {
                if (intfTypes != null && i < intfTypes.length) {
                    typeVarMap.put(vars[i].getName(), intfTypes[i]);
                    continue;
                }
                typeVarMap.put(vars[i].getName(), vars[i].getGenericDeclaration());
            }
            Type[] paramGenericTypes = intfMethod.getGenericParameterTypes();
            paramTypes = new Class[paramTypes.length];
            for (int i = 0; i < paramTypes.length; ++i) {
                if (paramGenericTypes[i] instanceof TypeVariable) {
                    TypeVariable tv = (TypeVariable)paramGenericTypes[i];
                    Type t = (Type)typeVarMap.get(tv.getName());
                    if (t == null) {
                        throw new RuntimeException("Unable to resolve type variable");
                    }
                    paramTypes[i] = Types.getRawType(t);
                    continue;
                }
                paramTypes[i] = Types.getRawType(paramGenericTypes[i]);
            }
        }
        try {
            return clazz.getMethod(intfMethod.getName(), paramTypes);
        }
        catch (NoSuchMethodException intfTypes) {
            try {
                Method tmp = clazz.getMethod(intfMethod.getName(), intfMethod.getParameterTypes());
                return tmp;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return intfMethod;
            }
        }
    }

    public static Class<?> getRawType(Type type) {
        TypeVariable typeVar;
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type rawType = parameterizedType.getRawType();
            return (Class)rawType;
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType genericArrayType = (GenericArrayType)type;
            Class<?> componentRawType = Types.getRawType(genericArrayType.getGenericComponentType());
            return Array.newInstance(componentRawType, 0).getClass();
        }
        if (type instanceof TypeVariable && (typeVar = (TypeVariable)type).getBounds() != null && typeVar.getBounds().length > 0) {
            return Types.getRawType(typeVar.getBounds()[0]);
        }
        throw new RuntimeException("unable to determine base class");
    }

    public static Class<?> getRawTypeNoException(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type rawType = parameterizedType.getRawType();
            return (Class)rawType;
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType genericArrayType = (GenericArrayType)type;
            Class<?> componentRawType = Types.getRawType(genericArrayType.getGenericComponentType());
            return Array.newInstance(componentRawType, 0).getClass();
        }
        return null;
    }

    public static Class<?> getTypeArgument(Type genericType) {
        if (!(genericType instanceof ParameterizedType)) {
            return null;
        }
        ParameterizedType parameterizedType = (ParameterizedType)genericType;
        Class typeArg = (Class)parameterizedType.getActualTypeArguments()[0];
        return typeArg;
    }

    public static Class getCollectionBaseType(Class type, Type genericType) {
        if (genericType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)genericType;
            Type componentGenericType = parameterizedType.getActualTypeArguments()[0];
            return Types.getRawType(componentGenericType);
        }
        if (genericType instanceof GenericArrayType) {
            GenericArrayType genericArrayType = (GenericArrayType)genericType;
            Type componentGenericType = genericArrayType.getGenericComponentType();
            return Types.getRawType(componentGenericType);
        }
        if (type.isArray()) {
            return type.getComponentType();
        }
        return null;
    }

    public static Class getMapKeyType(Type genericType) {
        if (genericType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)genericType;
            Type componentGenericType = parameterizedType.getActualTypeArguments()[0];
            return Types.getRawType(componentGenericType);
        }
        return null;
    }

    public static Class getMapValueType(Type genericType) {
        if (genericType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)genericType;
            Type componentGenericType = parameterizedType.getActualTypeArguments()[1];
            return Types.getRawType(componentGenericType);
        }
        return null;
    }

    public static Type resolveTypeVariables(Class<?> root, Type type) {
        if (type instanceof TypeVariable) {
            Type newType = Types.resolveTypeVariable(root, (TypeVariable)type);
            return newType == null ? type : newType;
        }
        if (type instanceof ParameterizedType) {
            final ParameterizedType param = (ParameterizedType)type;
            final Type[] actuals = new Type[param.getActualTypeArguments().length];
            for (int i = 0; i < actuals.length; ++i) {
                Type newType = Types.resolveTypeVariables(root, param.getActualTypeArguments()[i]);
                actuals[i] = newType == null ? param.getActualTypeArguments()[i] : newType;
            }
            return new ParameterizedType(){

                @Override
                public Type[] getActualTypeArguments() {
                    return actuals;
                }

                @Override
                public Type getRawType() {
                    return param.getRawType();
                }

                @Override
                public Type getOwnerType() {
                    return param.getOwnerType();
                }
            };
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType arrayType = (GenericArrayType)type;
            final Type componentType = Types.resolveTypeVariables(root, arrayType.getGenericComponentType());
            if (componentType == null) {
                return type;
            }
            return new GenericArrayType(){

                @Override
                public Type getGenericComponentType() {
                    return componentType;
                }
            };
        }
        return type;
    }

    public static Type resolveTypeVariable(Class<?> root, TypeVariable<?> typeVariable) {
        if (typeVariable.getGenericDeclaration() instanceof Class) {
            Class classDeclaringTypeVariable = (Class)typeVariable.getGenericDeclaration();
            Type[] types = Types.findParameterizedTypes(root, classDeclaringTypeVariable);
            if (types == null) {
                return null;
            }
            for (int i = 0; i < types.length; ++i) {
                TypeVariable tv = classDeclaringTypeVariable.getTypeParameters()[i];
                if (!tv.equals(typeVariable)) continue;
                return types[i];
            }
        }
        return null;
    }

    public static Type[] getActualTypeArgumentsOfAnInterface(Class<?> classToSearch, Class<?> interfaceToFind) {
        Type[] types = Types.findParameterizedTypes(classToSearch, interfaceToFind);
        if (types == null) {
            throw new RuntimeException("Unable to find type arguments");
        }
        return types;
    }

    public static Type[] findParameterizedTypes(Class<?> root, Class<?> searchedFor) {
        if (searchedFor.isInterface()) {
            return Types.findInterfaceParameterizedTypes(root, null, searchedFor);
        }
        return Types.findClassParameterizedTypes(root, null, searchedFor);
    }

    public static Type[] findClassParameterizedTypes(Class<?> root, ParameterizedType rootType, Class<?> searchedForClass) {
        if (Object.class.equals(root)) {
            return null;
        }
        Map<String, Type> typeVarMap = Types.populateParameterizedMap(root, rootType);
        Class<?> superclass = root.getSuperclass();
        Type genericSuper = root.getGenericSuperclass();
        if (superclass.equals(searchedForClass)) {
            return Types.extractTypes(typeVarMap, genericSuper);
        }
        if (genericSuper instanceof ParameterizedType) {
            ParameterizedType intfParam = (ParameterizedType)genericSuper;
            Type[] types = Types.findClassParameterizedTypes(superclass, intfParam, searchedForClass);
            if (types != null) {
                return Types.extractTypeVariables(typeVarMap, types);
            }
        } else {
            Type[] types = Types.findClassParameterizedTypes(superclass, null, searchedForClass);
            if (types != null) {
                return types;
            }
        }
        return null;
    }

    private static Map<String, Type> populateParameterizedMap(Class<?> root, ParameterizedType rootType) {
        HashMap<String, Type> typeVarMap = new HashMap<String, Type>();
        if (rootType != null) {
            TypeVariable<Class<?>>[] vars = root.getTypeParameters();
            for (int i = 0; i < vars.length; ++i) {
                typeVarMap.put(vars[i].getName(), rootType.getActualTypeArguments()[i]);
            }
        }
        return typeVarMap;
    }

    public static Type[] findInterfaceParameterizedTypes(Class<?> root, ParameterizedType rootType, Class<?> searchedForInterface) {
        int i;
        Map<String, Type> typeVarMap = Types.populateParameterizedMap(root, rootType);
        for (i = 0; i < root.getInterfaces().length; ++i) {
            Class<?> sub = root.getInterfaces()[i];
            Type genericSub = root.getGenericInterfaces()[i];
            if (!sub.equals(searchedForInterface)) continue;
            return Types.extractTypes(typeVarMap, genericSub);
        }
        for (i = 0; i < root.getInterfaces().length; ++i) {
            Class<?> sub;
            Type genericSub = root.getGenericInterfaces()[i];
            Type[] types = Types.recurseSuperclassForInterface(searchedForInterface, typeVarMap, genericSub, sub = root.getInterfaces()[i]);
            if (types == null) continue;
            return types;
        }
        if (root.isInterface()) {
            return null;
        }
        Class<?> superclass = root.getSuperclass();
        Type genericSuper = root.getGenericSuperclass();
        return Types.recurseSuperclassForInterface(searchedForInterface, typeVarMap, genericSuper, superclass);
    }

    private static Type[] recurseSuperclassForInterface(Class<?> searchedForInterface, Map<String, Type> typeVarMap, Type genericSub, Class<?> sub) {
        if (genericSub instanceof ParameterizedType) {
            ParameterizedType intfParam = (ParameterizedType)genericSub;
            Type[] types = Types.findInterfaceParameterizedTypes(sub, intfParam, searchedForInterface);
            if (types != null) {
                return Types.extractTypeVariables(typeVarMap, types);
            }
        } else {
            Type[] types = Types.findInterfaceParameterizedTypes(sub, null, searchedForInterface);
            if (types != null) {
                return types;
            }
        }
        return null;
    }

    private static Type[] extractTypeVariables(Map<String, Type> typeVarMap, Type[] types) {
        for (int j = 0; j < types.length; ++j) {
            if (types[j] instanceof TypeVariable) {
                TypeVariable tv = (TypeVariable)types[j];
                types[j] = typeVarMap.get(tv.getName());
                continue;
            }
            types[j] = types[j];
        }
        return types;
    }

    private static Type[] extractTypes(Map<String, Type> typeVarMap, Type genericSub) {
        if (genericSub instanceof ParameterizedType) {
            ParameterizedType param = (ParameterizedType)genericSub;
            Type[] types = param.getActualTypeArguments();
            Type[] returnTypes = new Type[types.length];
            System.arraycopy(types, 0, returnTypes, 0, types.length);
            Types.extractTypeVariables(typeVarMap, returnTypes);
            return returnTypes;
        }
        return EMPTY_TYPE_ARRAY;
    }

    public static <T> boolean supports(Class<T> type, Object object, Class<?> fromInterface) {
        Type providerType = Types.getActualTypeArgumentsOfAnInterface(object.getClass(), fromInterface)[0];
        Class<?> providerClass = Types.getRawType(providerType);
        return type.isAssignableFrom(providerClass);
    }
}

