/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.common.util;

import java.util.Arrays;
import java.util.Collection;

public abstract class PathMatcher<P> {
    private static final char WILDCARD = '*';

    public P matches(String targetUri) {
        int patternCount = 0;
        int bracketsPatternCount = 0;
        P matchingPath = null;
        P matchingAnyPath = null;
        P matchingAnySuffixPath = null;
        for (P entry : this.getPaths()) {
            String protectedSuffix;
            String pathString;
            String templateUri;
            String expectedUri = this.getPath(entry);
            if (expectedUri == null) continue;
            String matchingUri = null;
            if (this.exactMatch(expectedUri, targetUri)) {
                matchingUri = expectedUri;
            }
            if (this.isTemplate(expectedUri) && (templateUri = this.buildUriFromTemplate(expectedUri, targetUri, false)) != null) {
                int length = expectedUri.split("\\/").length;
                int bracketsLength = expectedUri.split("\\{").length;
                if (this.exactMatch(templateUri, targetUri) && (patternCount == 0 || length > patternCount || bracketsLength < bracketsPatternCount)) {
                    matchingUri = templateUri;
                    P resolved = this.resolvePathConfig(entry, targetUri);
                    if (resolved != null) {
                        entry = resolved;
                    }
                    patternCount = length;
                    bracketsPatternCount = bracketsLength;
                }
            }
            if (matchingUri == null) continue;
            StringBuilder path = new StringBuilder(expectedUri);
            int patternIndex = path.indexOf("/*");
            if (patternIndex != -1) {
                path.delete(patternIndex, path.length());
            }
            if ((patternIndex = path.indexOf("{")) != -1) {
                path.delete(patternIndex, path.length());
            }
            if ("".equals(pathString = path.toString())) {
                pathString = "/";
            }
            if (matchingUri.equals(targetUri) || pathString.equals(targetUri)) {
                if (patternCount == 0) {
                    return entry;
                }
                matchingPath = entry;
            }
            if ('*' == expectedUri.charAt(expectedUri.length() - 1)) {
                if (matchingAnyPath == null) {
                    matchingAnyPath = entry;
                    continue;
                }
                String resourcePath = this.getPath(matchingAnyPath);
                if (resourcePath.split("/").length >= matchingUri.split("/").length) continue;
                matchingAnyPath = entry;
                continue;
            }
            int suffixIndex = expectedUri.indexOf("*.");
            if (suffixIndex == -1 || !targetUri.endsWith(protectedSuffix = expectedUri.substring(suffixIndex + 1))) continue;
            matchingAnySuffixPath = entry;
        }
        if (matchingPath != null) {
            return matchingPath;
        }
        if (matchingAnySuffixPath != null) {
            return matchingAnySuffixPath;
        }
        return matchingAnyPath;
    }

    protected abstract String getPath(P var1);

    protected abstract Collection<P> getPaths();

    private boolean exactMatch(String expectedUri, String targetUri) {
        if (targetUri.equals(expectedUri)) {
            return true;
        }
        if (this.endsWithWildcard(expectedUri)) {
            String rootPath = expectedUri.substring(0, expectedUri.length() - 1);
            if (targetUri.startsWith(rootPath)) {
                return true;
            }
            return targetUri.equals(rootPath.substring(0, rootPath.length() - 1));
        }
        String suffix = "/*.";
        int suffixIndex = expectedUri.indexOf(suffix);
        if (suffixIndex != -1) {
            return targetUri.endsWith(expectedUri.substring(suffixIndex + suffix.length() - 1));
        }
        return false;
    }

    protected String buildUriFromTemplate(String template, String targetUri, boolean onlyFirstParam) {
        StringBuilder uri = new StringBuilder(template);
        String expectedUri = uri.toString();
        int patternStartIndex = expectedUri.indexOf("{");
        if (expectedUri.endsWith("/*")) {
            expectedUri = expectedUri.substring(0, expectedUri.length() - 2);
        }
        if (patternStartIndex == -1 || patternStartIndex >= targetUri.length()) {
            return null;
        }
        if (expectedUri.split("/").length > targetUri.split("/").length) {
            return null;
        }
        char[] expectedUriChars = expectedUri.toCharArray();
        char[] matchingUri = Arrays.copyOfRange(expectedUriChars, 0, patternStartIndex);
        int matchingUriLastIndex = matchingUri.length;
        String targetUriParams = targetUri.substring(patternStartIndex);
        if (Arrays.equals(matchingUri, Arrays.copyOf(targetUri.toCharArray(), matchingUri.length))) {
            matchingUri = Arrays.copyOf(matchingUri, targetUri.length());
            int paramIndex = 0;
            int lastPattern = 0;
            for (int i = patternStartIndex; i < expectedUriChars.length && matchingUriLastIndex < matchingUri.length; ++i) {
                char c = expectedUriChars[i];
                if (c == '{' || c == '*') {
                    String[] params = targetUriParams.split("/");
                    for (int k = paramIndex; k <= (c == '*' ? params.length : paramIndex) && k != params.length; ++k) {
                        int paramLength = params[k].length();
                        if (matchingUriLastIndex + paramLength > matchingUri.length) {
                            return null;
                        }
                        StringBuilder value = new StringBuilder();
                        for (int j = 0; j < paramLength; ++j) {
                            char valueChar = params[k].charAt(j);
                            value.append(valueChar);
                            matchingUri[matchingUriLastIndex++] = valueChar;
                        }
                        if (c == '{') {
                            uri.replace(uri.indexOf("{", lastPattern), uri.indexOf("}", lastPattern) + 1, value.toString());
                        }
                        if (value.charAt(value.length() - 1) == '}') {
                            lastPattern = uri.indexOf(value.toString()) + value.length();
                        }
                        if (c != '*' || matchingUriLastIndex >= matchingUri.length) continue;
                        matchingUri[matchingUriLastIndex++] = 47;
                    }
                    if (c == '{') {
                        i = expectedUri.indexOf(125, i);
                    }
                    if (i != expectedUri.lastIndexOf(125) || !onlyFirstParam) continue;
                    return String.valueOf(matchingUri).substring(0, matchingUriLastIndex);
                }
                if (c == '/') {
                    ++paramIndex;
                }
                matchingUri[matchingUriLastIndex++] = c;
            }
            return uri.toString();
        }
        return null;
    }

    public boolean endsWithWildcard(String expectedUri) {
        int length = expectedUri.length();
        return length > 0 && '*' == expectedUri.charAt(length - 1);
    }

    private boolean isTemplate(String uri) {
        return uri.indexOf("{") != -1;
    }

    protected P resolvePathConfig(P entry, String path) {
        return entry;
    }
}

