/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util;

import java.util.Optional;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.versioning.irac.IracEntryVersion;
import org.infinispan.container.versioning.irac.IracTombstoneManager;
import org.infinispan.metadata.impl.IracMetadata;
import org.infinispan.metadata.impl.PrivateMetadata;
import org.infinispan.util.logging.LogSupplier;

public final class IracUtils {
    private IracUtils() {
    }

    public static Optional<IracMetadata> findIracMetadataFromCacheEntry(CacheEntry<?, ?> entry) {
        PrivateMetadata privateMetadata = entry.getInternalMetadata();
        if (privateMetadata == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(privateMetadata.iracMetadata());
    }

    public static IracEntryVersion getIracVersionFromCacheEntry(CacheEntry<?, ?> entry) {
        return IracUtils.findIracMetadataFromCacheEntry(entry).map(IracMetadata::getVersion).orElse(null);
    }

    public static void setIracMetadata(CacheEntry<?, ?> entry, int segment, IracMetadata metadata, IracTombstoneManager versionGenerator, LogSupplier logSupplier) {
        Object key = entry.getKey();
        assert (metadata != null) : "[IRAC] Metadata must not be null!";
        if (entry.isRemoved()) {
            IracUtils.logTombstoneAssociated(key, metadata, logSupplier);
            versionGenerator.storeTombstone(segment, key, metadata);
        } else {
            IracUtils.logIracMetadataAssociated(key, metadata, logSupplier);
            IracUtils.updateCacheEntryMetadata(entry, metadata);
            versionGenerator.removeTombstone(key);
        }
    }

    public static void setPrivateMetadata(CacheEntry<?, ?> entry, int segment, PrivateMetadata metadata, IracTombstoneManager versionGenerator, LogSupplier logSupplier) {
        Object key = entry.getKey();
        assert (metadata.iracMetadata() != null) : "[IRAC] Metadata must not be null!";
        if (entry.isRemoved()) {
            IracUtils.logTombstoneAssociated(key, metadata.iracMetadata(), logSupplier);
            versionGenerator.storeTombstone(segment, key, metadata.iracMetadata());
        } else {
            IracUtils.logIracMetadataAssociated(key, metadata.iracMetadata(), logSupplier);
            entry.setInternalMetadata(metadata);
            versionGenerator.removeTombstone(key);
        }
    }

    public static void logUpdateDiscarded(Object key, IracMetadata metadata, LogSupplier logSupplier) {
        if (logSupplier.isTraceEnabled()) {
            logSupplier.getLog().tracef("[IRAC] Update from remote site discarded. Metadata=%s, key=%s", metadata, key);
        }
    }

    private static void logIracMetadataAssociated(Object key, IracMetadata metadata, LogSupplier logSupplier) {
        if (logSupplier.isTraceEnabled()) {
            logSupplier.getLog().tracef("[IRAC] IracMetadata %s associated with key '%s'", metadata, key);
        }
    }

    private static void logTombstoneAssociated(Object key, IracMetadata metadata, LogSupplier logSupplier) {
        if (logSupplier.isTraceEnabled()) {
            logSupplier.getLog().tracef("[IRAC] Store tombstone %s for key '%s'", metadata, key);
        }
    }

    private static void updateCacheEntryMetadata(CacheEntry<?, ?> entry, IracMetadata iracMetadata) {
        PrivateMetadata internalMetadata = PrivateMetadata.getBuilder(entry.getInternalMetadata()).iracMetadata(iracMetadata).build();
        entry.setInternalMetadata(internalMetadata);
    }
}

