/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.notifications.cachelistener.filter;

import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.metadata.Metadata;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilter;
import org.infinispan.notifications.cachelistener.filter.EventType;

@Scope(value=Scopes.NONE)
public class CompositeCacheEventFilter<K, V>
implements CacheEventFilter<K, V> {
    private final CacheEventFilter<? super K, ? super V>[] filters;

    public CompositeCacheEventFilter(CacheEventFilter<? super K, ? super V> ... filters) {
        this.filters = filters;
    }

    @Override
    public boolean accept(K key, V oldValue, Metadata oldMetadata, V newValue, Metadata newMetadata, EventType eventType) {
        for (CacheEventFilter<K, V> cacheEventFilter : this.filters) {
            if (cacheEventFilter.accept(key, oldValue, oldMetadata, newValue, newMetadata, eventType)) continue;
            return false;
        }
        return true;
    }

    @Inject
    protected void injectDependencies(ComponentRegistry cr) {
        for (CacheEventFilter<? super K, ? super V> f : this.filters) {
            cr.wireDependencies(f);
        }
    }
}

