/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.xsite;

import java.lang.invoke.MethodHandles;
import java.util.function.Predicate;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.configuration.cache.BackupConfiguration;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.context.impl.LocalTxInvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.ExceptionSyncInvocationStage;
import org.infinispan.interceptors.InvocationStage;
import org.infinispan.interceptors.xsite.BaseBackupInterceptor;
import org.infinispan.transaction.impl.AbstractCacheTransaction;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class OptimisticBackupInterceptor
extends BaseBackupInterceptor {
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private boolean hasOnePhaseCommitBackups;

    @Inject
    public void checkTwoPhaseCommit(Configuration configuration) {
        this.hasOnePhaseCommitBackups = configuration.sites().syncBackupsStream().anyMatch(Predicate.not(BackupConfiguration::isTwoPhaseCommit));
    }

    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) {
        if (OptimisticBackupInterceptor.skipXSiteBackup(command) || !command.hasAnyFlag(FlagBitSets.PUT_FOR_EXTERNAL_READ)) {
            return this.invokeNext(ctx, command);
        }
        return this.invokeNextThenApply(ctx, command, this.handleSingleKeyWriteReturn);
    }

    @Override
    public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) {
        if (!this.shouldInvokeRemoteTxCommand(ctx) || this.isTxFromRemoteSite(command.getGlobalTransaction())) {
            return this.invokeNext(ctx, command);
        }
        InvocationStage stage = this.backupSender.backupPrepare(command, (AbstractCacheTransaction)ctx.getCacheTransaction(), ctx.getTransaction());
        return this.invokeNextAndHandle(ctx, command, (rCtx, rCommand, rv, throwable) -> stage.andHandle(rCtx, rCommand, (rCtx1, rCommand1, rv1, throwable1) -> {
            if (log.isTraceEnabled()) {
                log.tracef("Response received from remote site for transaction %s: %s (throwable=%s)", rCommand1.getGlobalTransaction(), rv1, throwable1);
            }
            if (throwable != null) {
                if (throwable1 != null) {
                    throwable.addSuppressed(throwable1);
                }
                return new ExceptionSyncInvocationStage(throwable);
            }
            if (throwable1 != null) {
                return new ExceptionSyncInvocationStage(throwable1);
            }
            return rv;
        }));
    }

    @Override
    public Object visitCommitCommand(TxInvocationContext ctx, CommitCommand command) {
        if (this.isTxFromRemoteSite(command.getGlobalTransaction())) {
            return this.invokeNext(ctx, command);
        }
        InvocationStage stage = this.shouldInvokeRemoteTxCommand(ctx) ? this.backupSender.backupCommit(command, ctx.getTransaction()) : InvocationStage.completedNullStage();
        if (this.hasOnePhaseCommitBackups) {
            return OptimisticBackupInterceptor.makeStage(this.asyncInvokeNext((InvocationContext)ctx, (VisitableCommand)command, stage)).thenApply(ctx, command, (rCtx, rCommand, rv) -> {
                this.trackKeysForAsyncBackups((CommitCommand)rCommand);
                return rv;
            });
        }
        return this.invokeNextThenApply(ctx, command, (rCtx, rCommand, rv) -> {
            this.trackKeysForAsyncBackups((CommitCommand)rCommand);
            return stage.thenReturn(rCtx, rCommand, rv);
        });
    }

    @Override
    public Object visitRollbackCommand(TxInvocationContext ctx, RollbackCommand command) {
        if (!this.shouldInvokeRemoteTxCommand(ctx) || this.isTxFromRemoteSite(command.getGlobalTransaction())) {
            return this.invokeNext(ctx, command);
        }
        InvocationStage stage = this.backupSender.backupRollback(command, ctx.getTransaction());
        if (((LocalTxInvocationContext)ctx).getRemoteLocksAcquired().isEmpty()) {
            return this.invokeNext(ctx, command);
        }
        return this.invokeNextAndWaitForCrossSite(ctx, command, stage);
    }

    private void trackKeysForAsyncBackups(CommitCommand command) {
        GlobalTransaction gtx = command.getGlobalTransaction();
        this.keysFromMods(this.getModificationsFrom(command)).forEach(key -> this.iracManager.trackUpdatedKey(key.getSegment(), key.getKey(), gtx));
    }
}

