/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.globalstate.impl;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import org.infinispan.globalstate.ScopedPersistentState;

public class ScopedPersistentStateImpl
implements ScopedPersistentState {
    private final String scope;
    private final Map<String, String> state;

    public ScopedPersistentStateImpl(String scope) {
        this.scope = scope;
        this.state = new LinkedHashMap<String, String>();
    }

    @Override
    public String getScope() {
        return this.scope;
    }

    @Override
    public void setProperty(String key, String value) {
        this.state.put(key, value);
    }

    @Override
    public void setProperty(String key, int value) {
        this.setProperty(key, Integer.toString(value));
    }

    @Override
    public int getIntProperty(String key) {
        return Integer.parseInt(this.state.get(key));
    }

    @Override
    public void setProperty(String key, float f) {
        this.setProperty(key, Float.toString(f));
    }

    @Override
    public float getFloatProperty(String key) {
        return Float.parseFloat(this.state.get(key));
    }

    @Override
    public String getProperty(String key) {
        return this.state.get(key);
    }

    @Override
    public void forEach(BiConsumer<String, String> action) {
        this.state.forEach(action);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScopedPersistentStateImpl that = (ScopedPersistentStateImpl)o;
        if (this.scope != null ? !this.scope.equals(that.scope) : that.scope != null) {
            return false;
        }
        return this.state != null ? this.state.equals(that.state) : that.state == null;
    }

    public int hashCode() {
        int result = this.scope != null ? this.scope.hashCode() : 0;
        result = 31 * result + (this.state != null ? this.state.hashCode() : 0);
        return result;
    }

    @Override
    public int getChecksum() {
        int result = this.scope != null ? this.scope.hashCode() : 0;
        return result += this.state.entrySet().stream().filter(e -> !((String)e.getKey()).startsWith("@")).mapToInt(Map.Entry::hashCode).sum();
    }

    @Override
    public boolean containsProperty(String key) {
        return this.state.containsKey(key);
    }
}

