/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.ch.impl;

import org.infinispan.commons.hash.CRC16;
import org.infinispan.commons.hash.Hash;
import org.infinispan.commons.logging.Log;
import org.infinispan.commons.util.Util;
import org.infinispan.distribution.ch.impl.HashFunctionPartitioner;

public class RESPHashFunctionPartitioner
extends HashFunctionPartitioner {
    @Override
    public Hash getHash() {
        return CRC16.getInstance();
    }

    public static RESPHashFunctionPartitioner instance(int numSegments) {
        RESPHashFunctionPartitioner partitioner = new RESPHashFunctionPartitioner();
        partitioner.init(numSegments);
        return partitioner;
    }

    @Override
    protected void init(int numSegments) {
        if (!Util.isPow2((int)numSegments)) {
            throw Log.CONFIG.respCacheSegmentSizePow2(numSegments);
        }
        super.init(numSegments);
    }

    @Override
    protected int bitsToUse() {
        return 14;
    }
}

