/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.ch.impl;

import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.Configurations;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.persistence.manager.PersistenceStatus;

class KeyPartitionerDelegate
implements KeyPartitioner,
PersistenceManager.StoreChangeListener {
    private final KeyPartitioner keyPartitioner;
    private volatile boolean needSegments;

    public KeyPartitionerDelegate(KeyPartitioner keyPartitioner, Configuration configuration) {
        this.keyPartitioner = keyPartitioner;
        this.needSegments = Configurations.needSegments(configuration);
    }

    @Override
    public int getSegment(Object key) {
        return this.needSegments ? this.keyPartitioner.getSegment(key) : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeChanged(PersistenceStatus persistenceStatus) {
        KeyPartitionerDelegate keyPartitionerDelegate = this;
        synchronized (keyPartitionerDelegate) {
            this.needSegments = this.needSegments || persistenceStatus.usingSegmentedStore();
        }
    }
}

