/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.offheap;

import java.util.concurrent.locks.StampedLock;
import org.infinispan.commons.util.Util;

public class StripedLock {
    private final StampedLock[] locks;

    public StripedLock(int lockCount) {
        this.locks = new StampedLock[Util.findNextHighestPowerOfTwo((int)lockCount)];
        for (int i = 0; i < this.locks.length; ++i) {
            this.locks[i] = new StampedLock();
        }
    }

    public StampedLock getLockWithOffset(int offset) {
        if (offset >= this.locks.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.locks[offset];
    }

    public void lockAll() {
        for (StampedLock rwLock : this.locks) {
            rwLock.asWriteLock().lock();
        }
    }

    void unlockAll() {
        for (StampedLock rwLock : this.locks) {
            rwLock.asWriteLock().unlock();
        }
    }
}

