/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.Combine;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.cache.AbstractConfigurationChildBuilder;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.InvocationBatchingConfiguration;
import org.infinispan.configuration.cache.TransactionConfiguration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.util.logging.Log;

public class InvocationBatchingConfigurationBuilder
extends AbstractConfigurationChildBuilder
implements Builder<InvocationBatchingConfiguration> {
    private final AttributeSet attributes = InvocationBatchingConfiguration.attributeDefinitionSet();

    InvocationBatchingConfigurationBuilder(ConfigurationBuilder builder) {
        super(builder);
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public InvocationBatchingConfigurationBuilder enable() {
        this.attributes.attribute(InvocationBatchingConfiguration.ENABLED).set((Object)true);
        this.enableTransactions();
        return this;
    }

    public InvocationBatchingConfigurationBuilder disable() {
        this.attributes.attribute(InvocationBatchingConfiguration.ENABLED).set((Object)false);
        return this;
    }

    public InvocationBatchingConfigurationBuilder enable(boolean enable) {
        this.attributes.attribute(InvocationBatchingConfiguration.ENABLED).set((Object)enable);
        if (enable) {
            this.enableTransactions();
        }
        return this;
    }

    private void enableTransactions() {
        Attribute transactionModeAttribute = this.getBuilder().transaction().attributes.attribute(TransactionConfiguration.TRANSACTION_MODE);
        if (!transactionModeAttribute.isModified()) {
            this.getBuilder().transaction().transactionMode(TransactionMode.TRANSACTIONAL);
        }
    }

    boolean isEnabled() {
        return (Boolean)this.attributes.attribute(InvocationBatchingConfiguration.ENABLED).get();
    }

    public void validate() {
        if (this.isEnabled() && !this.getBuilder().transaction().transactionMode().isTransactional()) {
            throw Log.CONFIG.invocationBatchingNeedsTransactionalCache();
        }
        if (this.isEnabled() && this.getBuilder().transaction().recovery().isEnabled() && !this.getBuilder().transaction().useSynchronization()) {
            throw Log.CONFIG.invocationBatchingCannotBeRecoverable();
        }
    }

    @Override
    public void validate(GlobalConfiguration globalConfig) {
    }

    public InvocationBatchingConfiguration create() {
        return new InvocationBatchingConfiguration(this.attributes.protect());
    }

    public InvocationBatchingConfigurationBuilder read(InvocationBatchingConfiguration template, Combine combine) {
        this.attributes.read(template.attributes(), combine);
        return this;
    }

    public String toString() {
        return "InvocationBatchingConfigurationBuilder [attributes=" + String.valueOf(this.attributes) + "]";
    }
}

