/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.saml.processing.core.parsers.saml.protocol;

import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.StartElement;
import org.keycloak.dom.saml.v2.protocol.ExtensionsType;
import org.keycloak.dom.saml.v2.protocol.RequestAbstractType;
import org.keycloak.saml.common.exceptions.ParsingException;
import org.keycloak.saml.common.util.StaxParserUtil;
import org.keycloak.saml.processing.core.parsers.saml.protocol.AbstractStaxSamlProtocolParser;
import org.keycloak.saml.processing.core.parsers.saml.protocol.SAMLExtensionsParser;
import org.keycloak.saml.processing.core.parsers.saml.protocol.SAMLProtocolQNames;
import org.keycloak.saml.processing.core.parsers.util.SAMLParserUtil;

public abstract class SAMLRequestAbstractParser<T extends RequestAbstractType>
extends AbstractStaxSamlProtocolParser<T> {
    protected static final String VERSION_2_0 = "2.0";

    protected SAMLRequestAbstractParser(SAMLProtocolQNames expectedStartElement) {
        super(expectedStartElement);
    }

    protected void parseBaseAttributes(StartElement startElement, T request) throws ParsingException {
        request.setDestination(StaxParserUtil.getUriAttributeValue(startElement, SAMLProtocolQNames.ATTR_DESTINATION));
        request.setConsent(StaxParserUtil.getAttributeValue(startElement, SAMLProtocolQNames.ATTR_CONSENT));
    }

    protected void parseCommonElements(SAMLProtocolQNames element, StartElement elementDetail, XMLEventReader xmlEventReader, RequestAbstractType request) throws ParsingException {
        switch (element) {
            case ISSUER: {
                request.setIssuer(SAMLParserUtil.parseNameIDType(xmlEventReader));
                break;
            }
            case SIGNATURE: {
                request.setSignature(StaxParserUtil.getDOMElement(xmlEventReader));
                break;
            }
            case EXTENSIONS: {
                request.setExtensions((ExtensionsType)SAMLExtensionsParser.getInstance().parse(xmlEventReader));
            }
        }
    }
}

