/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.internal.otlp;

import io.opentelemetry.context.internal.shaded.WeakConcurrentMap;
import io.opentelemetry.exporter.internal.marshal.Marshaler;
import io.opentelemetry.exporter.internal.marshal.MarshalerUtil;
import io.opentelemetry.exporter.internal.marshal.MarshalerWithSize;
import io.opentelemetry.exporter.internal.marshal.ProtoFieldInfo;
import io.opentelemetry.exporter.internal.marshal.Serializer;
import io.opentelemetry.exporter.internal.otlp.KeyValueMarshaler;
import io.opentelemetry.proto.common.v1.internal.InstrumentationScope;
import io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;

public final class InstrumentationScopeMarshaler
extends MarshalerWithSize {
    private static final WeakConcurrentMap<InstrumentationScopeInfo, InstrumentationScopeMarshaler> SCOPE_MARSHALER_CACHE = new WeakConcurrentMap.WithInlinedExpunction();
    private final byte[] serializedBinary;
    private final String serializedJson;

    public static InstrumentationScopeMarshaler create(InstrumentationScopeInfo scopeInfo) {
        InstrumentationScopeMarshaler cached = (InstrumentationScopeMarshaler)((Object)SCOPE_MARSHALER_CACHE.get((Object)scopeInfo));
        if (cached == null) {
            byte[] name = MarshalerUtil.toBytes((String)scopeInfo.getName());
            byte[] version = MarshalerUtil.toBytes((String)scopeInfo.getVersion());
            KeyValueMarshaler[] attributes = KeyValueMarshaler.createForAttributes(scopeInfo.getAttributes());
            RealInstrumentationScopeMarshaler realMarshaler = new RealInstrumentationScopeMarshaler(name, version, attributes);
            ByteArrayOutputStream binaryBos = new ByteArrayOutputStream(realMarshaler.getBinarySerializedSize());
            try {
                realMarshaler.writeBinaryTo(binaryBos);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Serialization error, this is likely a bug in OpenTelemetry.", e);
            }
            String json = MarshalerUtil.preserializeJsonFields((Marshaler)realMarshaler);
            cached = new InstrumentationScopeMarshaler(binaryBos.toByteArray(), json);
            SCOPE_MARSHALER_CACHE.put((Object)scopeInfo, (Object)cached);
        }
        return cached;
    }

    private InstrumentationScopeMarshaler(byte[] binary, String json) {
        super(binary.length);
        this.serializedBinary = binary;
        this.serializedJson = json;
    }

    public void writeTo(Serializer output) throws IOException {
        output.writeSerializedMessage(this.serializedBinary, this.serializedJson);
    }

    private static final class RealInstrumentationScopeMarshaler
    extends MarshalerWithSize {
        private final byte[] name;
        private final byte[] version;
        private final KeyValueMarshaler[] attributes;

        RealInstrumentationScopeMarshaler(byte[] name, byte[] version, KeyValueMarshaler[] attributes) {
            super(RealInstrumentationScopeMarshaler.computeSize(name, version, attributes));
            this.name = name;
            this.version = version;
            this.attributes = attributes;
        }

        protected void writeTo(Serializer output) throws IOException {
            output.serializeString(InstrumentationScope.NAME, this.name);
            output.serializeString(InstrumentationScope.VERSION, this.version);
            output.serializeRepeatedMessage(InstrumentationScope.ATTRIBUTES, (Marshaler[])this.attributes);
        }

        private static int computeSize(byte[] name, byte[] version, KeyValueMarshaler[] attributes) {
            return MarshalerUtil.sizeBytes((ProtoFieldInfo)InstrumentationScope.NAME, (byte[])name) + MarshalerUtil.sizeBytes((ProtoFieldInfo)InstrumentationScope.VERSION, (byte[])version) + MarshalerUtil.sizeRepeatedMessage((ProtoFieldInfo)InstrumentationScope.ATTRIBUTES, (Marshaler[])attributes);
        }
    }
}

