/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.jdbc;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.dialect.Dialect;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.AdjustableJdbcType;
import org.hibernate.type.descriptor.jdbc.BasicBinder;
import org.hibernate.type.descriptor.jdbc.BasicExtractor;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeIndicators;
import org.hibernate.type.descriptor.jdbc.JsonArrayJdbcType;
import org.hibernate.type.descriptor.sql.spi.DdlTypeRegistry;

public class JsonAsStringArrayJdbcType
extends JsonArrayJdbcType
implements AdjustableJdbcType {
    private final boolean nationalized;
    private final int ddlTypeCode;

    public JsonAsStringArrayJdbcType(JdbcType elementJdbcType) {
        this(elementJdbcType, 4001);
    }

    public JsonAsStringArrayJdbcType(JdbcType elementJdbcType, int ddlTypeCode) {
        super(elementJdbcType);
        this.ddlTypeCode = ddlTypeCode;
        this.nationalized = ddlTypeCode == 4002 || ddlTypeCode == 2011;
    }

    @Override
    public int getJdbcTypeCode() {
        return this.nationalized ? -9 : 12;
    }

    @Override
    public int getDdlTypeCode() {
        return this.ddlTypeCode;
    }

    @Override
    public String toString() {
        return "JsonArrayAsStringJdbcType";
    }

    @Override
    public JdbcType resolveIndicatedType(JdbcTypeIndicators indicators, JavaType<?> domainJtd) {
        if (this.needsLob(indicators)) {
            return indicators.isNationalized() ? new JsonAsStringArrayJdbcType(this.getElementJdbcType(), 2011) : new JsonAsStringArrayJdbcType(this.getElementJdbcType(), 2005);
        }
        return indicators.isNationalized() ? new JsonAsStringArrayJdbcType(this.getElementJdbcType(), 4002) : new JsonAsStringArrayJdbcType(this.getElementJdbcType(), 4001);
    }

    protected boolean needsLob(JdbcTypeIndicators indicators) {
        long maxLength;
        Dialect dialect = indicators.getDialect();
        long length = indicators.getColumnLength();
        long l = maxLength = indicators.isNationalized() ? (long)dialect.getMaxNVarcharLength() : (long)dialect.getMaxVarcharLength();
        if (length > maxLength) {
            return true;
        }
        DdlTypeRegistry ddlTypeRegistry = indicators.getTypeConfiguration().getDdlTypeRegistry();
        String typeName = ddlTypeRegistry.getTypeName(this.getDdlTypeCode(), dialect);
        return typeName.equals(ddlTypeRegistry.getTypeName(2005, dialect)) || typeName.equals(ddlTypeRegistry.getTypeName(2011, dialect));
    }

    @Override
    public <X> ValueBinder<X> getBinder(JavaType<X> javaType) {
        if (this.nationalized) {
            return new BasicBinder<X>(javaType, this){

                @Override
                protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                    String json = ((JsonAsStringArrayJdbcType)this.getJdbcType()).toString(value, this.getJavaType(), options);
                    if (options.getDialect().supportsNationalizedMethods()) {
                        st.setNString(index, json);
                    } else {
                        st.setString(index, json);
                    }
                }

                @Override
                protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
                    String json = ((JsonAsStringArrayJdbcType)this.getJdbcType()).toString(value, this.getJavaType(), options);
                    if (options.getDialect().supportsNationalizedMethods()) {
                        st.setNString(name, json);
                    } else {
                        st.setString(name, json);
                    }
                }
            };
        }
        return super.getBinder(javaType);
    }

    @Override
    public <X> ValueExtractor<X> getExtractor(JavaType<X> javaType) {
        if (this.nationalized) {
            return new BasicExtractor<X>(javaType, this){

                @Override
                protected X doExtract(ResultSet rs, int paramIndex, WrapperOptions options) throws SQLException {
                    if (options.getDialect().supportsNationalizedMethods()) {
                        return this.getObject(rs.getNString(paramIndex), options);
                    }
                    return this.getObject(rs.getString(paramIndex), options);
                }

                @Override
                protected X doExtract(CallableStatement statement, int index, WrapperOptions options) throws SQLException {
                    if (options.getDialect().supportsNationalizedMethods()) {
                        return this.getObject(statement.getNString(index), options);
                    }
                    return this.getObject(statement.getString(index), options);
                }

                @Override
                protected X doExtract(CallableStatement statement, String name, WrapperOptions options) throws SQLException {
                    if (options.getDialect().supportsNationalizedMethods()) {
                        return this.getObject(statement.getNString(name), options);
                    }
                    return this.getObject(statement.getString(name), options);
                }

                private X getObject(String json, WrapperOptions options) throws SQLException {
                    return ((JsonAsStringArrayJdbcType)this.getJdbcType()).fromString(json, this.getJavaType(), options);
                }
            };
        }
        return super.getExtractor(javaType);
    }
}

